/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.IOxiModeReset;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.featuregroup.AbstractMode;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;

public class OxiOneRepeatModeConfigurationMode
extends AbstractMode<OxiOneControlSurface, OxiOneConfiguration>
implements IOxiModeReset {
    private static final String[] MENU = new String[]{"Rept", "Peri", "Lnth", "Mode"};
    private static final String[] SHIFTED_MENU = new String[]{"Rnge", "Hold", "", ""};
    private int selectedIndex = 0;
    private final IHost host = ((OxiOneControlSurface)this.surface).getHost();
    private final Configuration configuration = ((OxiOneControlSurface)this.surface).getConfiguration();
    private final INoteRepeat noteRepeat = ((OxiOneControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();

    public OxiOneRepeatModeConfigurationMode(OxiOneControlSurface surface, IModel model) {
        super("RepeatConfiguration", surface, model, false);
    }

    @Override
    public void updateDisplay() {
        this.updateSelectedIndex();
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        String desc = "";
        Object label = "";
        int value = -1;
        int upperBound = this.model.getValueChanger().getUpperBound();
        switch (this.selectedIndex) {
            case 0: {
                boolean isRepeatActive = this.configuration.isNoteRepeatActive();
                label = "Note Repeat: " + (isRepeatActive ? "On" : "Off");
                value = isRepeatActive ? upperBound : 0;
                break;
            }
            case 1: {
                Resolution noteRepeatPeriod = this.configuration.getNoteRepeatPeriod();
                label = "Period: " + noteRepeatPeriod.getName();
                value = (int)((double)noteRepeatPeriod.ordinal() / (double)(Resolution.values().length - 1) * (double)upperBound);
                break;
            }
            case 2: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                Resolution noteRepeatLength = this.configuration.getNoteRepeatLength();
                label = "Length: " + noteRepeatLength.getName();
                value = (int)((double)noteRepeatLength.ordinal() / (double)(Resolution.values().length - 1) * (double)upperBound);
                break;
            }
            case 3: {
                if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                ArpeggiatorMode noteRepeatMode = this.configuration.getNoteRepeatMode();
                label = "Mode: " + noteRepeatMode.getName();
                value = (int)((double)noteRepeatMode.ordinal() / (double)(ArpeggiatorMode.values().length - 1) * (double)upperBound);
                break;
            }
            case 4: {
                if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                int noteRepeatOctave = this.configuration.getNoteRepeatOctave();
                label = "Octave Range: " + noteRepeatOctave;
                value = (int)((double)noteRepeatOctave / 8.0 * (double)upperBound);
                break;
            }
            case 5: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LATCH)) break;
                boolean isLatchActive = this.noteRepeat.isLatchActive();
                label = "Hold: " + (isLatchActive ? "On" : "Off");
                value = isLatchActive ? upperBound : 0;
                break;
            }
        }
        display.addElement(new TitleValueMenuComponent("", (String)label, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, 0, 0, false));
        display.send();
    }

    private void updateSelectedIndex() {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
            if (this.selectedIndex < 4) {
                this.selectedIndex += 4;
            }
        } else if (this.selectedIndex >= 4) {
            this.selectedIndex -= 4;
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedIndex = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT) ? index + 4 : index;
    }

    @Override
    public void onKnobValue(int index, int value) {
        IValueChanger valueChanger = this.model.getValueChanger();
        boolean isInc = valueChanger.isIncrease(value);
        switch (this.selectedIndex) {
            case 0: {
                this.configuration.setNoteRepeatActive(isInc);
                break;
            }
            case 1: {
                int sel = Resolution.change(Resolution.getMatch(this.configuration.getNoteRepeatPeriod().getValue()), isInc);
                this.configuration.setNoteRepeatPeriod(Resolution.values()[sel]);
                break;
            }
            case 2: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                int sel2 = Resolution.change(Resolution.getMatch(this.configuration.getNoteRepeatLength().getValue()), valueChanger.calcKnobChange(value) > 0.0);
                this.configuration.setNoteRepeatLength(Resolution.values()[sel2]);
                break;
            }
            case 3: {
                if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                this.configuration.setPrevNextNoteRepeatMode(valueChanger.isIncrease(value));
                break;
            }
            case 4: {
                if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                this.configuration.setNoteRepeatOctave(this.configuration.getNoteRepeatOctave() + (valueChanger.calcKnobChange(value) > 0.0 ? 1 : -1));
                break;
            }
            case 5: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LATCH)) break;
                this.noteRepeat.setLatchActive(valueChanger.isIncrease(value));
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void resetValue(int index) {
        switch (this.selectedIndex) {
            case 0: {
                this.configuration.setNoteRepeatActive(false);
                break;
            }
            case 1: {
                this.configuration.setNoteRepeatPeriod(Resolution.RES_1_16);
                break;
            }
            case 2: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                this.configuration.setNoteRepeatLength(Resolution.RES_1_16);
                break;
            }
            case 3: {
                if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                this.configuration.setNoteRepeatMode(ArpeggiatorMode.UP);
                break;
            }
            case 4: {
                if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                this.configuration.setNoteRepeatOctave(0);
                break;
            }
            case 5: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LATCH)) break;
                this.noteRepeat.setLatchActive(false);
                break;
            }
        }
    }
}

