/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class OxiOneMk2ControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("4E7F5AC9-DE44-4D4A-ABDF-643EC9B6A585");

    public OxiOneMk2ControllerDefinition() {
        super(EXTENSION_ID, "One Mk2", "OXI", 1, 1);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                midiDiscoveryPairs.addAll(this.createDeviceDiscoveryPairs("OXI ONE MKII"));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("OXI ONE MKII MIDI 1", "OXI ONE MKII MIDI 1"));
                midiDiscoveryPairs.addAll(this.createLinuxDeviceDiscoveryPairs("OXI ONE MKII Jack 1", "OXI ONE MKII Jack 1"));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("OXI ONE MKII Jack 1", "OXI ONE MKII Jack 1"));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("OXI ONE MKII Anschluss 1", "OXI ONE MKII Anschluss 1"));
                break;
            }
        }
        return midiDiscoveryPairs;
    }
}

