/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class OxiOneConfiguration
extends AbstractConfiguration {
    public static final Integer PAD_BRIGHTNESS = 100;
    private static final List<String> BRIGHTNESS_OPTIONS = List.of("10%", "25%", "50%", "65%", "75%", "90%", "100%");
    private static final double[] BRIGHTNESS_VALUES = new double[]{0.1, 0.25, 0.5, 0.65, 0.75, 0.9, 1.0};
    private static final Views[] PREFERRED_NOTE_VIEWS_MK1 = new Views[]{Views.MIX, Views.DRUM_XOX, Views.PLAY, Views.DRUM64, Views.DRUM8, Views.SEQUENCER, Views.POLY_SEQUENCER, Views.RAINDROPS};
    private static final Views[] PREFERRED_NOTE_VIEWS_MK2 = new Views[]{Views.MIX, Views.SESSION, Views.DRUM_XOX, Views.PLAY, Views.DRUM64, Views.DRUM8, Views.SEQUENCER, Views.POLY_SEQUENCER, Views.RAINDROPS};
    private double padBrightness = 0.5;
    private final boolean isMk2;

    public OxiOneConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, boolean isMk2) {
        super(host, valueChanger, arpeggiatorModes);
        this.isMk2 = isMk2;
        Views.setViewName(Views.DRUM64, "Drum 128");
        this.accentActive = true;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings);
        this.activateNoteRepeatSetting(documentSettings);
        IEnumSetting padBrightnessSetting = globalSettings.getEnumSetting("Grid Pad Brightness", "Hardware Setup", BRIGHTNESS_OPTIONS, BRIGHTNESS_OPTIONS.get(2));
        padBrightnessSetting.addValueObserver(value -> {
            this.padBrightness = BRIGHTNESS_VALUES[OxiOneConfiguration.lookupIndex(BRIGHTNESS_OPTIONS, value)];
            this.notifyObservers(PAD_BRIGHTNESS);
        });
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateDrawRecordStripeSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateRecordButtonSetting(globalSettings);
        this.activateShiftedRecordButtonSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateMidiEditChannelSetting(documentSettings);
        this.activateTurnOffScalePadsSetting(globalSettings);
        this.activateShowPlayedChordsSetting(globalSettings);
        this.activateStartupViewSetting(globalSettings, this.isMk2 ? PREFERRED_NOTE_VIEWS_MK2 : PREFERRED_NOTE_VIEWS_MK1);
        if (this.host.supports(Capability.HAS_DRUM_DEVICE)) {
            this.activateTurnOffEmptyDrumPadsSetting(globalSettings);
        }
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
        this.activateColorTrackStates(globalSettings);
    }

    public double getPadBrightness() {
        return this.padBrightness;
    }
}

