/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.mode.device;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class DevicePresetsMode
extends AbstractParameterMode<SLControlSurface, SLConfiguration, IItem> {
    public static final int SELECTION_OFF = 0;
    private static final int SELECTION_PRESET = 1;
    private static final int SELECTION_FILTER = 2;
    private int selectionMode = 0;
    private int filterColumn = 0;

    public DevicePresetsMode(SLControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        block0 : switch (this.selectionMode) {
            case 0: {
                if (index < 2) {
                    this.navigatePresets(index == 1);
                    break;
                }
                this.selectionMode = 2;
                this.filterColumn = index - 2;
                break;
            }
            case 1: {
                switch (index) {
                    case 0: {
                        this.navigatePresets(false);
                        break block0;
                    }
                    case 1: {
                        this.navigatePresets(true);
                        break block0;
                    }
                    case 7: {
                        this.model.getBrowser().stopBrowsing(true);
                        ((SLControlSurface)this.surface).getModeManager().setActive(Modes.TRACK_DETAILS);
                        this.selectionMode = 0;
                        break block0;
                    }
                }
                this.selectionMode = 0;
                break;
            }
            case 2: {
                switch (index) {
                    case 0: {
                        this.navigateFilters(this.filterColumn, false);
                        break block0;
                    }
                    case 1: {
                        this.navigateFilters(this.filterColumn, true);
                        break block0;
                    }
                }
                this.selectionMode = 0;
                break;
            }
        }
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((SLControlSurface)this.surface).getTextDisplay().clear();
        if (!this.model.hasSelectedDevice()) {
            d.setRow(0, "                       Please select a device...                       ");
            d.done(0).done(1);
            return;
        }
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            d.setRow(0, "                     No active Browsing Session.                       ");
            d.setRow(1, "                        Press Browse again...                          ");
            d.done(0).done(1);
            return;
        }
        switch (this.selectionMode) {
            case 0: {
                String selectedResult = browser.getSelectedResult();
                d.setBlock(0, 0, "Preset:").setBlock(1, 0, selectedResult == null ? "None" : selectedResult);
                for (int i = 0; i < 6; ++i) {
                    IBrowserColumn column = browser.getFilterColumn(i);
                    String columnName = column.doesExist() ? StringUtils.shortenAndFixASCII(column.getName() + ":", 8) : "";
                    d.setCell(0, 2 + i, columnName).setCell(1, 2 + i, column.doesCursorExist() ? column.getCursorName() : "");
                }
                break;
            }
            case 1: {
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                for (int i = 0; i < 16; ++i) {
                    d.setCell(i % 2, i / 2, (results[i].isSelected() ? ">" : " ") + results[i].getName());
                }
                break;
            }
            case 2: {
                IBrowserColumnItem[] items = browser.getFilterColumn(this.filterColumn).getItems();
                for (int i = 0; i < 16; ++i) {
                    String name = StringUtils.fixASCII(items[i].getName());
                    String text = (items[i].isSelected() ? ">" : " ") + name + "                ";
                    if (!name.isEmpty()) {
                        String hitStr = "(" + items[i].getHitCount() + ")";
                        text = text.substring(0, 17 - hitStr.length()) + hitStr;
                    }
                    d.setCell(i % 2, i / 2, text);
                }
                break;
            }
        }
        d.done(0).done(1);
    }

    public void navigatePresets(boolean moveUp) {
        this.selectionMode = 1;
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        if (moveUp) {
            browser.selectNextResult();
        } else {
            browser.selectPreviousResult();
        }
    }

    public void navigateFilters(int filterNumber, boolean moveUp) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        if (moveUp) {
            browser.selectNextFilterItem(this.filterColumn);
        } else {
            browser.selectPreviousFilterItem(this.filterColumn);
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }
}

