/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.command.continuous;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.parameter.IParameter;

public class TouchpadCommand
extends AbstractContinuousCommand<SLControlSurface, SLConfiguration> {
    private final boolean isXDirection;

    public TouchpadCommand(boolean isXDirection, IModel model, SLControlSurface surface) {
        super(model, surface);
        this.isXDirection = isXDirection;
    }

    @Override
    public void execute(int value) {
        switch (((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).getTouchpadMode()) {
            case "Crossfader": {
                if (!this.isXDirection) break;
                this.model.getTransport().setCrossfade(value);
                break;
            }
            case "Remote Parameter 1&2": {
                ((IParameter)this.model.getCursorDevice().getParameterBank().getItem(this.isXDirection ? 0 : 1)).setValue(value);
                break;
            }
        }
    }
}

