/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.AbstractDrum64View;
import de.mossgrabers.framework.view.Views;

public class Drum64View
extends AbstractDrum64View<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    public Drum64View(LaunchpadControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    protected void handleDeleteButton(int playedPad) {
        ((LaunchpadControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
        int editMidiChannel = ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).getMidiEditChannel();
        this.model.getNoteClip(8, 128).clearRow(editMidiChannel, this.offsetY + playedPad);
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        return "BUTTON_STATE_OFF";
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        Drum64View drumView64 = (Drum64View)viewManager.get(Views.DRUM64);
        int drumOctave = drumView64.getDrumOctave();
        scrollStates.setCanScrollLeft(false);
        scrollStates.setCanScrollRight(false);
        scrollStates.setCanScrollUp(drumOctave < 1);
        scrollStates.setCanScrollDown(drumOctave > -2);
    }
}

