/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.command.trigger;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class SelectDeviceViewCommand
extends AbstractTriggerCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    public SelectDeviceViewCommand(IModel model, LaunchpadControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        if (((LaunchpadControlSurface)this.surface).isPro() && ((LaunchpadControlSurface)this.surface).isShiftPressed()) {
            if (viewManager.isActive(new Views[]{Views.SHIFT})) {
                viewManager.restore();
            }
            viewManager.setTemporary(Views.TEMPO);
            ((LaunchpadControlSurface)this.surface).getDisplay().notify(((IView)viewManager.getActive()).getName());
            return;
        }
        viewManager.setActive(viewManager.isActive(new Views[]{Views.DEVICE}) ? Views.USER : Views.DEVICE);
        ((LaunchpadControlSurface)this.surface).getDisplay().notify(((IView)viewManager.getActive()).getName());
    }

    public int getButtonColor() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        return viewManager.isActive(new Views[]{Views.DEVICE, Views.USER}) ? 30 : 1;
    }
}

