/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.mini.controller;

import de.mossgrabers.controller.novation.launchkey.mini.LaunchkeyMiniMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.mini.controller.LaunchkeyPadGrid;
import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.DeviceInquiry;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.Views;

public class LaunchkeyMiniMk3ControlSurface
extends AbstractControlSurface<LaunchkeyMiniMk3Configuration> {
    public static final int LAUNCHKEY_VIEW_SELECT = 3;
    public static final int LAUNCHKEY_MODE_SELECT = 9;
    public static final int LAUNCHKEY_DAW_ONLINE = 12;
    public static final int LAUNCHKEY_KNOB_1 = 21;
    public static final int LAUNCHKEY_KNOB_2 = 22;
    public static final int LAUNCHKEY_KNOB_3 = 23;
    public static final int LAUNCHKEY_KNOB_4 = 24;
    public static final int LAUNCHKEY_KNOB_5 = 25;
    public static final int LAUNCHKEY_KNOB_6 = 26;
    public static final int LAUNCHKEY_KNOB_7 = 27;
    public static final int LAUNCHKEY_KNOB_8 = 28;
    public static final int LAUNCHKEY_RIGHT = 102;
    public static final int LAUNCHKEY_LEFT = 103;
    public static final int LAUNCHKEY_SCENE1 = 104;
    public static final int LAUNCHKEY_SCENE2 = 105;
    public static final int LAUNCHKEY_SHIFT = 108;
    public static final int LAUNCHKEY_PLAY = 115;
    public static final int LAUNCHKEY_RECORD = 117;
    public static final int KNOB_MODE_VOLUME = 1;
    public static final int KNOB_MODE_PARAMS = 2;
    public static final int KNOB_MODE_PAN = 3;
    public static final int KNOB_MODE_SEND1 = 4;
    public static final int KNOB_MODE_SEND2 = 5;
    public static final int KNOB_MODE_CUSTOM = 6;
    public static final int PAD_MODE_DRUM = 1;
    public static final int PAD_MODE_SESSION = 2;
    public static final int PAD_MODE_CUSTOM = 5;
    private final ContinuousCommand pageAdjuster;
    private int lastPrgChange = -1;
    private boolean isDAWConnected = false;

    public LaunchkeyMiniMk3ControlSurface(IHost host, ColorManager colorManager, LaunchkeyMiniMk3Configuration configuration, IMidiOutput output, IMidiInput input, ContinuousCommand pageAdjuster) {
        super(host, configuration, colorManager, output, input, new LaunchkeyPadGrid(colorManager, output), 800.0, 600.0);
        int size = this.padGrid.getRows() * this.padGrid.getCols();
        for (int i = 0; i < size; ++i) {
            int note = this.padGrid.getStartNote() + i;
            ButtonID buttonID = ButtonID.get(ButtonID.PAD17, i);
            IHwButton pad = this.createButton(buttonID, "D " + (i + 1));
            pad.addLight(this.surfaceFactory.createLight(this.surfaceID, null, () -> this.padGrid.getLightInfo(note).getEncoded(), state -> this.padGrid.sendState(note), colorIndex -> this.colorManager.getColor(colorIndex, buttonID), null));
            int[] translated = LaunchkeyPadGrid.translateToController(Views.DRUM, note);
            pad.bind(input, BindType.NOTE, translated[0], translated[1]);
            pad.bind((event, velocity) -> this.handleGridNote(event, note, velocity));
        }
        this.pageAdjuster = pageAdjuster;
        this.input.setSysexCallback(this::handleSysEx);
        this.output.sendSysex(new byte[][]{DeviceInquiry.createQuery()});
    }

    @Override
    protected void internalShutdown() {
        this.setLaunchpadToDAW(false);
    }

    public void setLaunchpadToDAW(boolean enable) {
        this.output.sendNoteEx(15, 12, enable ? 127 : 0);
    }

    @Override
    public LaunchkeyPadGrid getPadGrid() {
        return (LaunchkeyPadGrid)super.getPadGrid();
    }

    @Override
    protected void handleProgramChange(int channel, int data1, int data2) {
        boolean isInc;
        boolean bl = isInc = this.lastPrgChange - data1 < 0;
        if (this.lastPrgChange == 127 && data1 == 0) {
            isInc = true;
        } else if (this.lastPrgChange == 0 && data1 == 127) {
            isInc = false;
        }
        this.lastPrgChange = data1;
        this.pageAdjuster.execute(isInc ? 1 : -1);
    }

    public void setKnobMode(int knobMode) {
        this.output.sendCCEx(15, 9, knobMode);
    }

    public void setPadMode(int padMode) {
        this.output.sendCCEx(15, 3, padMode);
    }

    public boolean isDAWConnected() {
        return this.isDAWConnected;
    }

    public void setDAWConnected(boolean isDAWConnected) {
        this.isDAWConnected = isDAWConnected;
    }

    private void handleSysEx(String data) {
        int[] byteData = StringUtils.fromHexStr(data);
        DeviceInquiry deviceInquiry = new DeviceInquiry(byteData);
        if (deviceInquiry.isValid()) {
            this.handleDeviceInquiryResponse(deviceInquiry);
        }
    }

    private void handleDeviceInquiryResponse(DeviceInquiry deviceInquiry) {
        int[] revisionLevel = deviceInquiry.getRevisionLevel();
        String firmwareVersion = String.format("%d%d%d%d", revisionLevel[0], revisionLevel[1], revisionLevel[2], revisionLevel[3]);
        this.host.println("Firmware version: " + (firmwareVersion.charAt(0) == '0' ? firmwareVersion.substring(1) : firmwareVersion));
    }
}

