/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.view;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyPadGrid;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.utils.ButtonEvent;

public class DeviceConfigView
extends AbstractView<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    public DeviceConfigView(LaunchkeyMk3ControlSurface surface, IModel model) {
        super("Device Configuration", surface, model);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int n = note - 36;
        int page = n < 8 ? n + 8 : n - 8;
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (cursorDevice.doesExist()) {
            cursorDevice.getParameterBank().getPageBank().selectPage(page);
        }
    }

    @Override
    public void drawGrid() {
        int i;
        LaunchkeyPadGrid padGrid = ((LaunchkeyMk3ControlSurface)this.surface).getPadGrid();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (!cursorDevice.doesExist()) {
            for (int i2 = 0; i2 < 16; ++i2) {
                padGrid.light(36 + i2, 0);
            }
        }
        IParameterPageBank parameterPageBank = cursorDevice.getParameterBank().getPageBank();
        int sel = parameterPageBank.getSelectedItemIndex();
        int lastPage = Math.min(16, parameterPageBank.getItemCount());
        for (i = 0; i < lastPage; ++i) {
            padGrid.lightEx(i % 8, i / 8, i == sel ? 53 : 55);
        }
        for (i = lastPage; i < 16; ++i) {
            padGrid.lightEx(i % 8, i / 8, 1);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        switch (buttonID) {
            case SCENE1: {
                return cursorDevice.isEnabled() ? 17 : 1;
            }
            case SCENE2: {
                return 0;
            }
            case ARROW_UP: {
                return cursorDevice.canSelectPrevious() ? 55 : 1;
            }
            case ARROW_DOWN: {
                return cursorDevice.canSelectNext() ? 55 : 1;
            }
        }
        return 0;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        switch (buttonID) {
            case SCENE1: {
                cursorDevice.toggleEnabledState();
                break;
            }
            case SCENE2: {
                break;
            }
            case ARROW_UP: {
                cursorDevice.selectPrevious();
                break;
            }
            case ARROW_DOWN: {
                cursorDevice.selectNext();
                break;
            }
        }
    }
}

