/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine;

public enum Maschine {
    JAM("Maschine JAM", "1500", true, false, true, true, 440, 2),
    MIKRO_MK3("Maschine Mikro Mk3", "1700", false, false, false, false, 440, 0),
    MK2("Maschine Mk2", "0000", false, true, true, true, 714, 0),
    MK3("Maschine Mk3", "1600", true, true, true, true, 800, 2),
    PLUS("Maschine+", "1820", true, true, true, true, 800, 2),
    STUDIO("Maschine Studio", "1300", false, true, true, true, 700, 4);

    private static final String MESSAGE_SHIFT_DOWN = "F0002109%s4D5000014D01F7";
    private static final String MESSAGE_SHIFT_UP = "F0002109%s4D5000014D00F7";
    private static final String MESSAGE_RETURN_FROM_HOST = "F0002109%s4D5000014601F7";
    private final String name;
    private final String maschineID;
    private final boolean hasShift;
    private final boolean hasMCUDisplay;
    private final boolean hasGroupButtons;
    private final boolean hasCursorKeys;
    private final int height;
    private final int footswitches;
    private final String messageShiftDown;
    private final String messageShiftUp;
    private final String messageReturnFromHost;

    private Maschine(String name, String maschineID, boolean hasShift, boolean hasMCUDisplay, boolean hasGroupButtons, boolean hasCursorKeys, int height, int footswitches) {
        this.name = name;
        this.maschineID = maschineID;
        this.hasShift = hasShift;
        this.hasMCUDisplay = hasMCUDisplay;
        this.hasGroupButtons = hasGroupButtons;
        this.hasCursorKeys = hasCursorKeys;
        this.height = height;
        this.footswitches = footswitches;
        this.messageShiftDown = String.format(MESSAGE_SHIFT_DOWN, this.maschineID);
        this.messageShiftUp = String.format(MESSAGE_SHIFT_UP, this.maschineID);
        this.messageReturnFromHost = String.format(MESSAGE_RETURN_FROM_HOST, this.maschineID);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasShift() {
        return this.hasShift;
    }

    public boolean hasMCUDisplay() {
        return this.hasMCUDisplay;
    }

    public boolean hasGroupButtons() {
        return this.hasGroupButtons;
    }

    public boolean hasCursorKeys() {
        return this.hasCursorKeys;
    }

    public double getWidth() {
        return this == STUDIO ? 1150.0 : 800.0;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFootswitches() {
        return this.footswitches;
    }

    public String getMessageShiftDown() {
        return this.messageShiftDown;
    }

    public String getMessageShiftUp() {
        return this.messageShiftUp;
    }

    public String getMessageReturnFromHost() {
        return this.messageReturnFromHost;
    }
}

