/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.mode.device;

import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.ni.kontrol.mki.mode.AbstractKontrol1Mode;
import de.mossgrabers.framework.command.trigger.BrowserCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Locale;

public class BrowseMode
extends AbstractKontrol1Mode<IItem> {
    public static final int SELECTION_OFF = 0;
    private static final int SELECTION_PRESET = 1;
    private static final int SELECTION_FILTER = 2;
    private int selectionMode = 0;
    private int filterColumn = 0;
    protected int selectedColumn = -1;

    public BrowseMode(Kontrol1ControlSurface surface, IModel model) {
        super("Browse", surface, model);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (!isTouched) {
            return;
        }
        int n = this.selectedColumn = this.selectedColumn != -1 ? -1 : index;
        if (this.selectedColumn == -1) {
            this.selectionMode = 0;
            return;
        }
        if (index == 7) {
            this.selectionMode = 1;
            this.filterColumn = -1;
        } else {
            IBrowser browser = this.model.getBrowser();
            IBrowserColumn fc = browser.getFilterColumn(index);
            if (fc != null && fc.doesExist()) {
                this.selectionMode = 2;
                this.filterColumn = fc.getIndex();
            }
        }
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((Kontrol1ControlSurface)this.surface).getTextDisplay();
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        d.clear();
        switch (this.selectionMode) {
            case 0: {
                d.setCell(0, 0, "BROWSE").setCell(1, 0, browser.getSelectedContentType().toUpperCase(Locale.US));
                String selectedResult = browser.getSelectedResult();
                d.setCell(0, 8, "SELECTED").setCell(1, 8, selectedResult == null ? "NONE" : selectedResult);
                for (int i = 0; i < 7; ++i) {
                    IBrowserColumn column = browser.getFilterColumn(i);
                    d.setCell(0, 1 + i, StringUtils.shortenAndFixASCII(column.getName() + ":", 8).toUpperCase(Locale.US)).setCell(1, 1 + i, column.doesCursorExist() ? column.getCursorName().toUpperCase(Locale.US) : "");
                }
                break;
            }
            case 1: {
                d.setCell(0, 0, "SELECTED");
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                for (int i = 0; i < 16; ++i) {
                    d.setCell(i % 2, 1 + i / 2, (results[i].isSelected() ? ">" : " ") + results[i].getName().toUpperCase(Locale.US));
                }
                break;
            }
            case 2: {
                IBrowserColumn fc = browser.getFilterColumn(this.filterColumn);
                d.setCell(0, 0, fc.getName().toUpperCase(Locale.US));
                IBrowserColumnItem[] items = fc.getItems();
                for (int i = 0; i < 16; ++i) {
                    String name = items[i].getName().toUpperCase(Locale.US);
                    String text = (items[i].isSelected() ? ">" : " ") + name;
                    d.setCell(i % 2, 1 + i / 2, text);
                }
                break;
            }
        }
        d.allDone();
    }

    public void selectNext(int count) {
        block3: {
            IBrowser browser;
            block2: {
                int index = this.selectedColumn == -1 ? 7 : this.selectedColumn;
                browser = this.model.getBrowser();
                if (index >= 7) break block2;
                IBrowserColumn fc = browser.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) break block3;
                this.filterColumn = fc.getIndex();
                for (int i = 0; i < count; ++i) {
                    browser.selectNextFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) break block3;
                browser.nextFilterItemPage(this.filterColumn);
                break block3;
            }
            for (int i = 0; i < count; ++i) {
                browser.selectNextResult();
            }
        }
    }

    public void selectPrevious(int count) {
        int index = this.selectedColumn == -1 ? 7 : this.selectedColumn;
        IBrowser browser = this.model.getBrowser();
        for (int i = 0; i < count; ++i) {
            if (index < 7) {
                IBrowserColumn fc = browser.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) continue;
                this.filterColumn = fc.getIndex();
                for (int j = 0; j < count; ++j) {
                    browser.selectPreviousFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) continue;
                browser.previousFilterItemPage(this.filterColumn);
                continue;
            }
            for (int j = 0; j < count; ++j) {
                browser.selectPreviousResult();
            }
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        switch (buttonID) {
            case MUTE: 
            case SOLO: {
                return "BUTTON_STATE_ON";
            }
            case BROWSE: {
                return "BUTTON_STATE_HI";
            }
        }
        return "BUTTON_STATE_OFF";
    }

    @Override
    public void onMainKnob(int value) {
        if (value > 64) {
            this.selectPrevious(1);
        } else {
            this.selectNext(1);
        }
    }

    @Override
    public void onMainKnobPressed() {
        this.onKnobTouch(7, true);
    }

    @Override
    public void onBack() {
        ((BrowserCommand)((Kontrol1ControlSurface)this.surface).getButton(ButtonID.BROWSE).getCommand()).startBrowser(true, true);
    }

    @Override
    public void onEnter() {
        ((BrowserCommand)((Kontrol1ControlSurface)this.surface).getButton(ButtonID.BROWSE).getCommand()).startBrowser(false, false);
    }

    @Override
    public void selectPreviousItem() {
        this.model.getBrowser().previousContentType();
    }

    @Override
    public void selectNextItem() {
        this.model.getBrowser().nextContentType();
    }

    @Override
    public void selectPreviousItemPage() {
    }

    @Override
    public void selectNextItemPage() {
    }
}

