/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.mode;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Locale;

public class BrowserMode
extends AbstractParameterMode<FireControlSurface, FireConfiguration, IItem> {
    public BrowserMode(FireControlSurface surface, IModel model) {
        super("Browser", surface, model, false);
        this.initTouchedStates(9);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        for (int i = 0; i < 4; ++i) {
            ((IHwRelativeKnob)((FireControlSurface)this.surface).getContinuous(ContinuousID.get(ContinuousID.KNOB1, i))).setSensitivity(1.0);
        }
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.model.getBrowser().stopBrowsing(true);
        int knobSensitivityDefault = ((FireConfiguration)((FireControlSurface)this.surface).getConfiguration()).getKnobSensitivityDefault();
        for (int i = 0; i < 4; ++i) {
            ((IHwRelativeKnob)((FireControlSurface)this.surface).getContinuous(ContinuousID.get(ContinuousID.KNOB1, i))).setSensitivity(knobSensitivityDefault);
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        int idx = this.getKnobIndex(index);
        int speed = this.model.getValueChanger().calcSteppedKnobChange(value);
        if (index == 8 && ((FireControlSurface)this.surface).isPressed(ButtonID.SELECT)) {
            ((FireControlSurface)this.surface).getButton(ButtonID.SELECT).setConsumed();
            speed *= 4;
        }
        if (speed > 0) {
            this.selectNext(idx, speed);
        } else {
            this.selectPrevious(idx, -speed);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        int idx = this.getKnobIndex(index);
        for (int i = 0; i < 8; ++i) {
            if (!this.isKnobTouched(i) || i == idx) continue;
            return;
        }
        this.setTouchedKnob(idx, isTouched);
    }

    private int getKnobIndex(int index) {
        int idx = 8;
        if (index < 8) {
            idx = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) ? 4 + index : index;
        }
        return idx;
    }

    @Override
    public void updateDisplay() {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        String[] rows = new String[3];
        boolean[] sels = new boolean[]{false, false, false};
        IGraphicDisplay display = ((FireControlSurface)this.surface).getGraphicsDisplay();
        int idx = this.getTouchedKnob();
        if (idx < 0) {
            String selectedResult = browser.getSelectedResult();
            rows[0] = browser.getSelectedContentType().toUpperCase(Locale.US);
            rows[1] = "Selection: ";
            rows[2] = selectedResult == null || selectedResult.isBlank() ? "None" : selectedResult;
        } else if (idx == 8) {
            IBrowserColumnItem[] results = browser.getResultColumnItems();
            if (results[0].doesExist()) {
                for (int item = 0; item < 3; ++item) {
                    rows[item] = item < results.length ? results[item].getName() : "";
                    sels[item] = item < results.length && results[item].isSelected();
                }
            } else {
                rows[0] = "No";
                rows[1] = "results ";
                rows[2] = "available...";
            }
        } else {
            IBrowserColumn filterColumn = browser.getFilterColumn(idx);
            if (filterColumn.doesExist() && filterColumn.doesCursorExist()) {
                IBrowserColumnItem[] item = filterColumn.getItems();
                for (int itemIndex = 0; itemIndex < 3; ++itemIndex) {
                    int pos = itemIndex;
                    Object text = StringUtils.optimizeName(item[pos].getName(), 10);
                    if (!((String)text).isEmpty()) {
                        text = (String)text + " (" + item[pos].getHitCount() + ")";
                    }
                    rows[itemIndex] = text;
                    sels[itemIndex] = item[pos].isSelected();
                }
            } else {
                rows[0] = "";
                rows[1] = "";
                rows[2] = "";
            }
        }
        display.addListElement(rows, sels);
        display.send();
    }

    @Override
    public void selectPreviousItem() {
        this.model.getBrowser().previousContentType();
    }

    @Override
    public void selectNextItem() {
        this.model.getBrowser().nextContentType();
    }

    @Override
    public boolean hasPreviousItem() {
        return this.model.getBrowser().hasPreviousContentType();
    }

    @Override
    public boolean hasNextItem() {
        return this.model.getBrowser().hasNextContentType();
    }

    @Override
    public boolean hasPreviousItemPage() {
        return this.hasPreviousItem();
    }

    @Override
    public boolean hasNextItemPage() {
        return this.hasNextItem();
    }

    private void selectNext(int index, int count) {
        block4: {
            IBrowser browser;
            block3: {
                browser = this.model.getBrowser();
                int filterColumnCount = Math.min(browser.getFilterColumnCount(), 7);
                if (index >= filterColumnCount) break block3;
                IBrowserColumn fc = browser.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) break block4;
                int fi = fc.getIndex();
                if (fi < 0) {
                    return;
                }
                for (int i = 0; i < count; ++i) {
                    browser.selectNextFilterItem(fi);
                }
                break block4;
            }
            for (int i = 0; i < count; ++i) {
                browser.selectNextResult();
            }
        }
    }

    private void selectPrevious(int index, int count) {
        block4: {
            IBrowser browser;
            block3: {
                browser = this.model.getBrowser();
                int filterColumnCount = Math.min(browser.getFilterColumnCount(), 7);
                if (index >= filterColumnCount) break block3;
                IBrowserColumn fc = browser.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) break block4;
                int fi = fc.getIndex();
                if (fi < 0) {
                    return;
                }
                for (int j = 0; j < count; ++j) {
                    browser.selectPreviousFilterItem(fi);
                }
                break block4;
            }
            for (int j = 0; j < count; ++j) {
                browser.selectPreviousResult();
            }
        }
    }
}

