/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.command.trigger;

import de.mossgrabers.controller.akai.fire.command.trigger.AbstractFireViewMultiSelectCommand;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class DrumSequencerSelectCommand
extends AbstractFireViewMultiSelectCommand {
    public DrumSequencerSelectCommand(IModel model, FireControlSurface surface) {
        super(model, surface, Views.DRUM, Views.DRUM4, Views.DRUM64);
    }

    public int getViewActivationColor() {
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.DRUM})) {
            return 1;
        }
        if (viewManager.isActive(new Views[]{Views.DRUM4})) {
            return 2;
        }
        if (viewManager.isActive(new Views[]{Views.DRUM64})) {
            return 3;
        }
        return 0;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        Views preferredView;
        if (event != ButtonEvent.UP) {
            return;
        }
        this.getNoteEditor().clearNotes();
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        boolean doesExist = cursorTrack.doesExist();
        int position = cursorTrack.getPosition();
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.SESSION, Views.MIX}) && doesExist && (preferredView = viewManager.getPreferredView(position)) != null && this.viewIds.contains((Object)preferredView)) {
            viewManager.setActive(preferredView);
            return;
        }
        super.executeNormal(event);
        if (doesExist) {
            viewManager.setPreferredView(position, (Views)((Object)viewManager.getActiveID()));
        }
    }

    private INoteEditor getNoteEditor() {
        return ((INoteEditorMode)((FireControlSurface)this.surface).getModeManager().get(Modes.NOTE)).getNoteEditor();
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITransport transport = this.model.getTransport();
        transport.tapTempo();
        this.mvHelper.delayDisplay(() -> String.format("Tempo: %.02f", transport.getTempo()));
    }
}

