/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.EchoOSCMessageListener;
import com.illposed.osc.OSCBadDataEvent;
import com.illposed.osc.OSCBadDataListener;
import com.illposed.osc.messageselector.JavaRegexAddressMessageSelector;
import com.illposed.osc.transport.OSCPortIn;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleEchoServer
extends OSCPortIn {
    public static final int DEFAULT_PORT = 7770;
    private static final int ARG_INDEX_ADDRESS = 0;
    private static final int ARG_INDEX_PORT = 1;
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleEchoServer.class);
    private final Logger log;

    public ConsoleEchoServer(SocketAddress serverAddress, Logger log) throws IOException {
        super(serverAddress);
        this.log = log;
    }

    public void start() {
        EchoOSCMessageListener listener = new EchoOSCMessageListener(this.log);
        this.getDispatcher().addListener(new JavaRegexAddressMessageSelector(".*"), listener);
        this.getDispatcher().addBadDataListener(new PrintBadDataListener());
        this.setResilient(true);
        this.setDaemonListener(false);
        this.startListening();
        this.log.info("# Listening for OSC Packets via {} ...", (Object)this.getTransport());
    }

    public static SocketAddress parseServerAddress(String[] args) throws UnknownHostException {
        InetAddress host;
        int port = 7770;
        if (args.length > 0) {
            host = InetAddress.getByName(args[0]);
            if (args.length > 1) {
                try {
                    port = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException ex) {
                    LOG.error("# ERROR: Invalid port: {}", (Object)args[1]);
                    throw ex;
                }
            }
        } else {
            host = null;
        }
        return new InetSocketAddress(host, port);
    }

    public static void main(String[] args) throws IOException {
        new ConsoleEchoServer(ConsoleEchoServer.parseServerAddress(args), LoggerFactory.getLogger(ConsoleEchoServer.class)).start();
    }

    private final class PrintBadDataListener
    implements OSCBadDataListener {
        PrintBadDataListener() {
        }

        @Override
        public void badDataReceived(OSCBadDataEvent evt) {
            if (ConsoleEchoServer.this.log.isWarnEnabled()) {
                ConsoleEchoServer.this.log.warn("Bad packet received while listening on " + ConsoleEchoServer.this.toString() + " ...", (Throwable)evt.getException());
                ConsoleEchoServer.this.log.warn("### Received data (bad): ###\n{}\n###\n\n", (Object)new String(evt.getData().array(), StandardCharsets.UTF_8));
            }
        }
    }
}

