/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.widget;

import de.mossgrabers.reaper.ui.widget.Functions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class GradientTitledBorder
extends TitledBorder {
    private static final long serialVersionUID = 3257565118169625144L;
    Color gradientColor1;
    Color gradientColor2;

    public GradientTitledBorder(String title) {
        this(title, UIManager.getColor("textHighlightText"), UIManager.getColor("controlShadow"), UIManager.getColor("control"));
    }

    public GradientTitledBorder(String title, Color titleColor, Color gradientColor1, Color gradientColor2) {
        super(null, Functions.getText(title));
        this.setTitleColor(titleColor);
        this.gradientColor1 = gradientColor1;
        this.gradientColor2 = gradientColor2;
        Font f = this.getTitleFont();
        if (f == null && (f = UIManager.getFont("Label.font")) == null) {
            f = new Font("SansSerif", 1, 12);
        }
        this.setTitleFont(f);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(g instanceof Graphics2D)) {
            throw new ClassCastException("Parameter g must be an instance of Graphics2D but is " + String.valueOf(g.getClass()) + ".");
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(new GradientPaint(x, y, this.gradientColor1, (float)x + (float)width, y, this.gradientColor2));
        int h = this.getBorderInsets((Component)c).top;
        g2.fillRect(x, y, width, y + h);
        Font f = this.getTitleFont();
        Rectangle2D bounds = f.getStringBounds(this.getTitle(), g2.getFontRenderContext());
        super.paintBorder(c, g2, x, y + (int)((double)h - bounds.getHeight()) / 2, width, height);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(7 + this.getTitleFont().getSize() + 7, 0, 0, 0);
    }

    @Override
    public Border getBorder() {
        return null;
    }
}

