/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.AbstractHwControl;
import de.mossgrabers.framework.controller.hardware.IHwTextDisplay;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.reaper.framework.graphics.GraphicsContextImpl;
import de.mossgrabers.reaper.framework.hardware.Bounds;
import de.mossgrabers.reaper.framework.hardware.HwControlLayout;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;

public class HwTextDisplayImpl
extends AbstractHwControl
implements IHwTextDisplay,
IReaperHwControl {
    private final HwControlLayout layout;
    private final String[] lines;

    public HwTextDisplayImpl(String id, int numLines) {
        super(null, null);
        this.layout = new HwControlLayout(id);
        this.lines = new String[numLines];
    }

    @Override
    public void setLine(int line, String text) {
        this.lines[line] = text;
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.layout.setBounds(x, y, width, height);
    }

    @Override
    public void draw(IGraphicsContext gc, double scale) {
        Bounds bounds = this.layout.getBounds();
        if (bounds == null || this.lines[0] == null) {
            return;
        }
        double x = bounds.x() * scale;
        double y = bounds.y() * scale;
        double width = bounds.width() * scale;
        double height = bounds.height() * scale / (double)this.lines.length;
        double fontSize = ((GraphicsContextImpl)gc).calculateFontSize(this.lines[0], height, width, 6.0);
        for (int i = 0; i < this.lines.length; ++i) {
            if (this.lines[i] == null) continue;
            gc.drawTextInBounds(this.lines[i], x, y + (double)i * height, width, height, Align.LEFT, ColorEx.WHITE, fontSize);
        }
    }

    @Override
    public void mouse(int mouseEvent, double x, double y, double scale) {
    }
}

