/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.parameter;

import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;

public class VolumeParameterImpl
extends ParameterImpl {
    private static final Object VOLUME_UPDATE_LOCK = new Object();

    public VolumeParameterImpl(DataSetupEx dataSetup, int index, double defaultValue) {
        super(dataSetup, index, defaultValue);
        this.setInternalName("Volume");
    }

    @Override
    public void touchValue(boolean isBeingTouched) {
        this.sender.processIntArg(Processor.TRACK, this.createCommand("volume/touch"), isBeingTouched ? 1 : 0);
        super.touchValue(isBeingTouched);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendValue() {
        Object object = VOLUME_UPDATE_LOCK;
        synchronized (object) {
            if (this.isAutomationRecActive()) {
                this.sender.delayUpdates(Processor.TRACK);
            }
            this.sender.processDoubleArg(Processor.TRACK, this.createCommand("volume"), this.value);
        }
    }

    @Override
    protected String createCommand(String command) {
        return this.getIndex() + "/" + command;
    }
}

