/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.bank.AbstractItemBank;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import java.util.List;
import java.util.Optional;

public abstract class AbstractBankImpl<T extends IItem>
extends AbstractItemBank<T> {
    protected final DataSetupEx dataSetup;
    protected final BackendExchange sender;
    protected final IValueChanger valueChanger;
    protected int itemCount;

    protected AbstractBankImpl(DataSetupEx dataSetup, int pageSize) {
        super(dataSetup == null ? null : dataSetup.getHost(), pageSize);
        this.dataSetup = dataSetup;
        this.sender = dataSetup != null ? dataSetup.getSender() : null;
        this.valueChanger = dataSetup != null ? dataSetup.getValueChanger() : null;
    }

    protected AbstractBankImpl(DataSetupEx dataSetup, int pageSize, List<T> items) {
        super(dataSetup == null ? null : dataSetup.getHost(), pageSize, items);
        this.dataSetup = dataSetup;
        this.sender = dataSetup != null ? dataSetup.getSender() : null;
        this.valueChanger = dataSetup != null ? dataSetup.getValueChanger() : null;
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public void scrollBackwards() {
    }

    @Override
    public void scrollForwards() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canScrollPageBackwards() {
        List list = this.items;
        synchronized (list) {
            return !this.items.isEmpty() && ((IItem)this.getItem(0)).getPosition() > 0;
        }
    }

    @Override
    public boolean canScrollPageForwards() {
        Optional sel = this.getSelectedItem();
        return sel.isPresent() && ((IItem)sel.get()).getPosition() < this.getItemCount() - 1;
    }

    @Override
    public void scrollTo(int position) {
        this.scrollTo(position, true);
    }

    @Override
    public void scrollTo(int position, boolean adjustPage) {
    }
}

