/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IDeviceMetadata;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.ItemImpl;
import de.mossgrabers.reaper.framework.daw.data.MuteParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.SendBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.PanningParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.VolumeParameterImpl;
import de.mossgrabers.reaper.framework.device.DeviceMetadataImpl;
import java.util.HashSet;
import java.util.Set;

public class ChannelImpl
extends ItemImpl
implements IChannel {
    private static final Object MUTE_UPDATE_LOCK = new Object();
    private static final ColorEx GRAY = new ColorEx(0.2, 0.2, 0.2);
    private final Set<IValueObserver<ColorEx>> colorObservers = new HashSet<IValueObserver<ColorEx>>();
    private ChannelType type;
    private double vu;
    private double vuLeft;
    private double vuRight;
    private double vuHoldDbLeft;
    private double vuHoldDbRight;
    private int vuPeakLeft;
    private int vuPeakRight;
    private int vuPeakLastVolume;
    private boolean isMute;
    private boolean isSolo;
    private boolean isActivated = true;
    private ColorEx color;
    private final ParameterImpl volumeParameter;
    private final ParameterImpl panParameter;
    private final IParameter muteParameter;
    private final IParameter soloParameter;
    private final ISendBank sendBank;

    public ChannelImpl(DataSetupEx dataSetup, int index, int numSends) {
        this(dataSetup, index, numSends, new VolumeParameterImpl(dataSetup, index, 0.716), new PanningParameterImpl(dataSetup, index, 0.5));
    }

    public ChannelImpl(DataSetupEx dataSetup, int index, int numSends, ParameterImpl volumeParameter, ParameterImpl panParameter) {
        super(dataSetup, index);
        this.setInternalName("Track");
        this.volumeParameter = volumeParameter;
        this.panParameter = panParameter;
        this.muteParameter = new MuteParameterImpl(this.valueChanger, this, index);
        this.soloParameter = new MuteParameterImpl(this.valueChanger, this, index);
        this.sendBank = new SendBankImpl(dataSetup, this, numSends);
    }

    @Override
    public void setExists(boolean exists) {
        super.setExists(exists);
        this.volumeParameter.setExists(exists);
        this.panParameter.setExists(exists);
    }

    @Override
    public void enter() {
    }

    @Override
    public ChannelType getType() {
        return this.type == null ? ChannelType.UNKNOWN : this.type;
    }

    @Override
    public boolean isActivated() {
        return this.doesExist() && this.isActivated;
    }

    @Override
    public IParameter getVolumeParameter() {
        return this.volumeParameter;
    }

    @Override
    public String getVolumeStr() {
        return this.doesExist() ? this.volumeParameter.getDisplayedValue() : "";
    }

    @Override
    public String getVolumeStr(int limit) {
        String vs = this.getVolumeStr();
        return vs.length() > limit ? vs.substring(0, limit) : vs;
    }

    @Override
    public int getVolume() {
        return this.volumeParameter.getValue();
    }

    @Override
    public void changeVolume(int control) {
        this.volumeParameter.changeValue(control);
    }

    @Override
    public void setVolume(int value) {
        this.volumeParameter.setValue(value);
    }

    @Override
    public void resetVolume() {
        this.setVolume((int)(0.716 * (double)this.valueChanger.getUpperBound()));
    }

    @Override
    public void touchVolume(boolean isBeingTouched) {
        this.volumeParameter.touchValue(isBeingTouched);
    }

    @Override
    public void setVolumeIndication(boolean indicate) {
    }

    @Override
    public int getModulatedVolume() {
        return this.getVolume();
    }

    @Override
    public IParameter getPanParameter() {
        return this.panParameter;
    }

    @Override
    public String getPanStr() {
        return this.doesExist() ? this.panParameter.getDisplayedValue() : "";
    }

    @Override
    public String getPanStr(int limit) {
        String ps = this.getPanStr();
        return ps.length() > limit ? ps.substring(0, limit) : ps;
    }

    @Override
    public int getPan() {
        return this.panParameter.getValue();
    }

    @Override
    public void changePan(int control) {
        this.panParameter.changeValue(control);
    }

    @Override
    public void setPan(int value) {
        this.panParameter.setValue(value);
    }

    @Override
    public void resetPan() {
        this.setPan(this.valueChanger.getUpperBound() / 2);
    }

    @Override
    public void touchPan(boolean isBeingTouched) {
        this.panParameter.touchValue(isBeingTouched);
    }

    @Override
    public void setPanIndication(boolean indicate) {
    }

    @Override
    public int getModulatedPan() {
        return this.getPan();
    }

    @Override
    public ColorEx getColor() {
        return this.color == null ? GRAY : this.color;
    }

    @Override
    public void setColor(ColorEx color) {
        int[] rgb = color.toIntRGB255();
        this.sendPositionedItemOSC("color", "RGB(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + ")");
    }

    @Override
    public IParameter getMuteParameter() {
        return this.muteParameter;
    }

    @Override
    public boolean isMute() {
        return this.doesExist() && this.isMute;
    }

    @Override
    public IParameter getSoloParameter() {
        return this.soloParameter;
    }

    @Override
    public boolean isSolo() {
        return this.doesExist() && this.isSolo;
    }

    @Override
    public boolean isMutedBySolo() {
        return false;
    }

    @Override
    public int getVu() {
        return this.valueChanger.fromNormalizedValue(this.vu);
    }

    @Override
    public int getVuLeft() {
        return this.valueChanger.fromNormalizedValue(this.vuLeft);
    }

    @Override
    public int getVuRight() {
        return this.valueChanger.fromNormalizedValue(this.vuRight);
    }

    @Override
    public int getVuPeakLeft() {
        this.checkPeakVolume();
        int vuLeftAdjusted = this.getVuLeft();
        if (vuLeftAdjusted > this.vuPeakLeft) {
            this.vuPeakLeft = vuLeftAdjusted;
        }
        return this.vuPeakLeft;
    }

    @Override
    public int getVuPeakRight() {
        this.checkPeakVolume();
        int vuRightAdjusted = this.getVuRight();
        if (vuRightAdjusted > this.vuPeakRight) {
            this.vuPeakRight = vuRightAdjusted;
        }
        return this.vuPeakRight;
    }

    protected void checkPeakVolume() {
        int volume = this.volumeParameter.getValue();
        if (this.vuPeakLastVolume == volume) {
            return;
        }
        this.vuPeakLastVolume = volume;
        this.vuPeakLeft = 0;
        this.vuPeakRight = 0;
    }

    @Override
    public boolean getVuClipState() {
        return this.getVuLeftClipState() || this.getVuRightClipState();
    }

    @Override
    public boolean getVuLeftClipState() {
        return this.vuHoldDbLeft > 0.0;
    }

    @Override
    public boolean getVuRightClipState() {
        return this.vuHoldDbRight > 0.0;
    }

    @Override
    public void setIsActivated(boolean enable) {
        this.isActivated = enable;
        this.sendPositionedItemOSC("active", enable);
    }

    @Override
    public void toggleIsActivated() {
        this.setIsActivated(!this.isActivated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMute(boolean value) {
        Object object = MUTE_UPDATE_LOCK;
        synchronized (object) {
            if (this.isAutomationRecActive()) {
                this.sender.delayUpdates(Processor.TRACK);
            }
            this.setMuteState(value);
            this.sendPositionedItemOSC("mute", value);
        }
    }

    @Override
    public void toggleMute() {
        this.setMute(!this.isMute());
    }

    @Override
    public void setSolo(boolean value) {
        this.setSoloState(value);
        this.sendPositionedItemOSC("solo", value);
    }

    @Override
    public void toggleSolo() {
        this.setSolo(!this.isSolo());
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("ChannelImpl.select not implemented. Only use with TrackImpl!");
    }

    @Override
    public void toggleMultiSelect() {
        throw new UnsupportedOperationException("ChannelImpl.toggleMultiSelect not implemented. Only use with TrackImpl!");
    }

    public void setType(ChannelType type) {
        this.type = type;
    }

    public void setInternalVolume(double volume) {
        this.volumeParameter.setInternalValue(volume);
    }

    public void setVolumeStr(String volumeStr) {
        this.volumeParameter.setValueStr(volumeStr);
    }

    public void setInternalPan(double pan) {
        this.panParameter.setInternalValue(pan);
    }

    public void setPanStr(String panStr) {
        this.panParameter.setValueStr(panStr);
    }

    public void setVu(double vu) {
        this.vu = vu;
    }

    public void setVuLeft(double vuLeft) {
        this.vuLeft = vuLeft;
    }

    public void setVuRight(double vuRight) {
        this.vuRight = vuRight;
    }

    public void setVuHoldLeft(double vuHoldLeft) {
        this.vuHoldDbLeft = vuHoldLeft;
    }

    public void setVuHoldRight(double vuHoldRight) {
        this.vuHoldDbRight = vuHoldRight;
    }

    public void setMuteState(boolean isMute) {
        this.isMute = isMute;
    }

    public void setSoloState(boolean isSolo) {
        this.isSolo = isSolo;
    }

    public void setInternalIsActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public void setColorState(double[] color) {
        this.color = new ColorEx(color);
        this.colorObservers.forEach(observer -> observer.update(this.color));
    }

    @Override
    public void duplicate() {
        this.select();
        this.host.scheduleTask(() -> this.sender.invokeAction(40062), 200L);
    }

    @Override
    public void remove() {
        this.sendPositionedItemOSC("remove");
    }

    @Override
    public ISendBank getSendBank() {
        return this.sendBank;
    }

    @Override
    public void addColorObserver(IValueObserver<ColorEx> observer) {
        this.colorObservers.add(observer);
    }

    @Override
    public void addDevice(IDeviceMetadata metadata) {
        this.sender.processStringArg(Processor.DEVICE, "add/0", ((DeviceMetadataImpl)metadata).getCreationName());
    }

    @Override
    public void addEqualizerDevice() {
        this.sender.processNoArg(Processor.EQ, "add");
    }

    @Override
    protected Processor getProcessor() {
        return Processor.TRACK;
    }
}

