/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.reaper.framework.configuration.BaseValueSetting;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;

public class IntegerSettingImpl
extends BaseValueSetting<JFormattedTextField, Integer>
implements IIntegerSetting {
    private final int minValue;
    private final int maxValue;
    private final int initialValue;
    private int value;

    public IntegerSettingImpl(LogModel logModel, PropertiesEx properties, String label, String category, int initialValue, int minValue, int maxValue) {
        super(logModel, label, category, new JFormattedTextField(NumberFormat.getIntegerInstance()));
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.initialValue = initialValue;
        this.load(properties);
        ((JFormattedTextField)this.field).setValue(initialValue);
        ((JFormattedTextField)this.field).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SafeRunLater.execute(IntegerSettingImpl.this.logModel, () -> {
                    try {
                        IntegerSettingImpl.this.set(Integer.parseInt(((JFormattedTextField)IntegerSettingImpl.this.field).getText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
            }
        });
    }

    @Override
    public void set(Integer value) {
        this.set((int)value);
    }

    @Override
    public void set(int value) {
        if (value < this.minValue || value > this.maxValue) {
            return;
        }
        this.value = value;
        this.setDirty();
        this.flush();
        SafeRunLater.execute(this.logModel, () -> {
            String v = ((JFormattedTextField)this.field).getText();
            if (!v.equals(Integer.toString(this.value))) {
                ((JFormattedTextField)this.field).setText(Integer.toString(this.value));
            }
        });
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), Integer.toString(this.value));
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getInt(this.getID(), this.initialValue));
    }

    @Override
    public void reset() {
        this.set(this.initialValue);
    }
}

