/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.featuregroup.AbstractView;

public class ScenePlayView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C> {
    public static final String COLOR_SELECTED_PLAY_SCENE = "COLOR_SELECTED_PLAY_SCENE";
    private final ISceneBank sceneBank;

    public ScenePlayView(S surface, IModel model) {
        super("Scene Play", surface, model);
        IPadGrid padGrid = this.surface.getPadGrid();
        this.sceneBank = model.getSceneBank(padGrid.getRows() * padGrid.getCols());
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = this.surface.getPadGrid();
        int rows = padGrid.getRows();
        int cols = padGrid.getCols();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int pad = row * cols + col;
                IScene scene = (IScene)this.sceneBank.getItem(pad);
                String colorID = scene.isSelected() ? COLOR_SELECTED_PLAY_SCENE : (scene.doesExist() ? DAWColor.getColorID(scene.getColor()) : "GRID_COLOR_OFF");
                padGrid.lightEx(col, rows - row - 1, colorID);
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        boolean isPressed;
        int sceneIndex = note - 36;
        IScene scene = (IScene)this.sceneBank.getItem(sceneIndex);
        boolean bl = isPressed = velocity > 0;
        if (isPressed) {
            if (this.handleSceneButtonCombinations(sceneIndex, scene)) {
                return;
            }
            scene.select();
            this.surface.getDisplay().notify(scene.getName());
            if (this.isSceneSelectAction()) {
                return;
            }
        }
        scene.launch(isPressed, this.isSceneLaunchAlternateAction());
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 8) {
            return "BUTTON_COLOR_OFF";
        }
        return "COLOR_RESOLUTION_OFF";
    }
}

