/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.parameter.AbstractStaticParameter;

public class StaticPercentageParameter
extends AbstractStaticParameter {
    private final double defaultValue;
    private double value;

    public StaticPercentageParameter(String name, IValueChanger valueChanger, double defaultValue) {
        super(name, valueChanger);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    public double getRawValue() {
        return this.value;
    }

    @Override
    public void inc(double incrementValue) {
        this.value = Math.clamp(this.value + this.valueChanger.toNormalizedValue(incrementValue), 0.0, 1.0);
    }

    @Override
    public String getDisplayedValue() {
        return String.format("%d%%", (int)Math.round(this.value * 100.0));
    }

    @Override
    public int getValue() {
        return (int)Math.round(this.value * (double)this.valueChanger.getUpperBound());
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.value = Math.clamp(this.valueChanger.toNormalizedValue(value), 0.0, 1.0);
    }

    @Override
    public void setNormalizedValue(double value) {
        this.value = Math.clamp(value, 0.0, 1.0);
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(this.valueChanger, value);
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int control) {
        int v = valueChanger.changeValue(control, this.valueChanger.fromNormalizedValue(this.value));
        this.value = Math.clamp(this.valueChanger.toNormalizedValue(v), 0.0, 1.0);
    }

    @Override
    public void resetValue() {
        this.value = this.defaultValue;
    }
}

