/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.parameter.AbstractStaticParameter;

public class StaticIntegerRangeParameter
extends AbstractStaticParameter {
    private final int minValue;
    private final int maxValue;
    private final int defaultValue;
    private int value;

    public StaticIntegerRangeParameter(String name, IValueChanger valueChanger, int minValue, int maxValue, int defaultValue) {
        super(name, valueChanger);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    public int getRawValue() {
        return this.value;
    }

    @Override
    public void inc(double incrementValue) {
        this.value = Math.clamp((long)(this.value + (incrementValue > 0.0 ? 1 : -1)), this.minValue, this.maxValue);
    }

    @Override
    public String getDisplayedValue() {
        return Integer.toString(this.value);
    }

    @Override
    public int getValue() {
        double range = this.maxValue - this.minValue;
        double v = this.value - this.minValue;
        return (int)Math.round(v / range * (double)this.valueChanger.getUpperBound());
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.value = Math.clamp((long)value, this.minValue, this.maxValue);
    }

    @Override
    public void setNormalizedValue(double value) {
        this.value = Math.clamp((long)this.valueChanger.fromNormalizedValue(value), this.minValue, this.maxValue);
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(this.valueChanger, value);
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int control) {
        this.value = Math.clamp((long)(this.value + (valueChanger.isIncrease(control) ? 1 : -1)), this.minValue, this.maxValue);
    }

    @Override
    public void resetValue() {
        this.value = this.defaultValue;
    }
}

