/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.osc;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.osc.IOpenSoundControlConfiguration;
import java.util.List;

public abstract class AbstractOpenSoundControlConfiguration
extends AbstractConfiguration
implements IOpenSoundControlConfiguration {
    public static final Integer LOG_INPUT_COMMANDS = 100;
    public static final Integer LOG_OUTPUT_COMMANDS = 101;
    public static final Integer FILTER_HEARTBEAT_COMMANDS = 102;
    protected static final String DEFAULT_SERVER = "127.0.0.1";
    private boolean logInputCommands = false;
    private boolean logOutputCommands = false;
    private boolean filterHeartbeatCommands = false;

    protected AbstractOpenSoundControlConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
    }

    protected void activateOSCLogging(ISettingsUI settingsUI) {
        IEnumSetting logInputCommandsSetting = settingsUI.getEnumSetting("Log input commands", "Debug", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        logInputCommandsSetting.addValueObserver(value -> {
            this.logInputCommands = "On".equals(value);
            this.notifyObservers(LOG_INPUT_COMMANDS);
        });
        IEnumSetting logOutputCommandsSetting = settingsUI.getEnumSetting("Log output commands", "Debug", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        logOutputCommandsSetting.addValueObserver(value -> {
            this.logOutputCommands = "On".equals(value);
            this.notifyObservers(LOG_OUTPUT_COMMANDS);
        });
        IEnumSetting filterHeartbeatCommandsSetting = settingsUI.getEnumSetting("Filter heartbeat commands (ping etc.)", "Debug", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        filterHeartbeatCommandsSetting.addValueObserver(value -> {
            this.filterHeartbeatCommands = "On".equals(value);
            this.notifyObservers(FILTER_HEARTBEAT_COMMANDS);
        });
        this.isSettingActive.add(LOG_INPUT_COMMANDS);
        this.isSettingActive.add(LOG_OUTPUT_COMMANDS);
        this.isSettingActive.add(FILTER_HEARTBEAT_COMMANDS);
    }

    @Override
    public boolean shouldLogInputCommands() {
        return this.logInputCommands;
    }

    @Override
    public boolean shouldLogOutputCommands() {
        return this.logOutputCommands;
    }

    @Override
    public boolean filterHeartbeatMessages() {
        return this.filterHeartbeatCommands;
    }
}

