/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics;

import de.mossgrabers.framework.graphics.DefaultBounds;
import de.mossgrabers.framework.graphics.IBounds;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;

public class DefaultGraphicsInfo
implements IGraphicsInfo {
    private final IGraphicsContext gc;
    private final IGraphicsConfiguration configuration;
    private final IGraphicsDimensions dimensions;
    private final IBounds bounds;

    public DefaultGraphicsInfo(IGraphicsContext gc, IGraphicsConfiguration configuration, IGraphicsDimensions dimensions) {
        this.gc = gc;
        this.configuration = configuration;
        this.dimensions = dimensions;
        this.bounds = null;
    }

    public DefaultGraphicsInfo(IGraphicsContext gc, IGraphicsConfiguration configuration, IGraphicsDimensions dimensions, IBounds bounds) {
        this.gc = gc;
        this.configuration = configuration;
        this.dimensions = dimensions;
        this.bounds = bounds;
    }

    @Override
    public IGraphicsContext getContext() {
        return this.gc;
    }

    @Override
    public IGraphicsConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public IGraphicsDimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public IBounds getBounds() {
        return this.bounds;
    }

    @Override
    public IGraphicsInfo withBounds(double top, double height) {
        return this.withBounds(this.bounds.left(), top, this.bounds.width(), height);
    }

    @Override
    public IGraphicsInfo withBounds(double left, double top, double width, double height) {
        return new DefaultGraphicsInfo(this.gc, this.configuration, this.dimensions, new DefaultBounds(left, top, width, height));
    }
}

