/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.aftertouch;

import de.mossgrabers.framework.command.core.AbstractAftertouchCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;

public class AftertouchViewCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractAftertouchCommand<S, C> {
    protected IView view;

    public AftertouchViewCommand(IView view, IModel model, S surface) {
        super(model, surface);
        this.view = view;
    }

    @Override
    public void onPolyAftertouch(int note, int value) {
        Object config = this.surface.getConfiguration();
        int convertAftertouch = config.getConvertAftertouch();
        switch (convertAftertouch) {
            case -3: {
                break;
            }
            case -2: {
                int n = this.view.getKeyManager().getMidiNoteFromGrid(note);
                if (n == -1) {
                    return;
                }
                this.surface.sendMidiEvent(160, n, value);
                break;
            }
            case -1: {
                this.surface.sendMidiEvent(208, value, 0);
                break;
            }
            default: {
                this.surface.sendMidiEvent(176, convertAftertouch, value);
            }
        }
    }

    @Override
    public void onChannelAftertouch(int value) {
        int convertAftertouch = this.surface.getConfiguration().getConvertAftertouch();
        if (convertAftertouch == -3) {
            return;
        }
        if (convertAftertouch == -2) {
            for (Integer key : this.view.getKeyManager().getPressedKeys()) {
                this.onPolyAftertouch(key, value);
            }
        } else {
            this.onPolyAftertouch(-1, value);
        }
    }
}

