/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.view;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.AbstractSessionView;
import java.util.Optional;

public class OxiOneSessionView
extends AbstractSessionView<OxiOneControlSurface, OxiOneConfiguration>
implements IScrollableView {
    protected boolean isShowTemporarily;
    private final OxiOneConfiguration configuration;

    public OxiOneSessionView(OxiOneControlSurface surface, IModel model) {
        super("Session", surface, model, 8, 16, true);
        this.ignoreClipColorForPlayAndRecord = true;
        this.configuration = (OxiOneConfiguration)((OxiOneControlSurface)this.surface).getConfiguration();
        int redLo = 6;
        int redHi = 4;
        boolean black = false;
        boolean white = true;
        int green = 2;
        int amber = 11;
        int gray = 18;
        LightInfo isRecording = new LightInfo(4, -1, false);
        LightInfo isRecordingQueued = new LightInfo(4, 0, true);
        LightInfo isPlaying = new LightInfo(2, -1, false);
        LightInfo isPlayingQueued = new LightInfo(2, 2, true);
        LightInfo isStopQueued = new LightInfo(2, 2, true);
        LightInfo hasContent = new LightInfo(11, 1, false);
        LightInfo noContent = new LightInfo(0, -1, false);
        LightInfo recArmed = new LightInfo(6, -1, false);
        LightInfo isMuted = new LightInfo(18, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, isStopQueued, hasContent, noContent, recArmed, isMuted);
        this.birdColorHasContent = hasContent;
        this.birdColorSelected = new LightInfo(2, -1, false);
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        ITrackBank tb;
        ISceneBank sceneBank;
        IScene s;
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if ((index >= 0 || index < 8) && (s = (IScene)(sceneBank = (tb = this.model.getCurrentTrackBank()).getSceneBank()).getItem(index)).doesExist()) {
            return DAWColor.getColorID(s.getColor());
        }
        return "BUTTON_COLOR_OFF";
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        boolean result = super.handleButtonCombinations(track, slot);
        if (this.isButtonCombination(ButtonID.DELETE) && this.configuration.isDeleteModeActive()) {
            this.configuration.toggleDeleteModeActive();
        } else if (this.isButtonCombination(ButtonID.DUPLICATE) && this.configuration.isDuplicateModeActive() && (!slot.doesExist() || !slot.hasContent())) {
            this.configuration.toggleDuplicateModeActive();
        }
        return result;
    }

    @Override
    protected boolean isButtonCombination(ButtonID buttonID) {
        if (super.isButtonCombination(buttonID) || buttonID == ButtonID.DELETE && this.configuration.isDeleteModeActive()) {
            return true;
        }
        return buttonID == ButtonID.DUPLICATE && this.configuration.isDuplicateModeActive();
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional sel = tb.getSelectedItem();
        int selIndex = sel.isPresent() ? ((ITrack)sel.get()).getIndex() : -1;
        ISceneBank sceneBank = tb.getSceneBank();
        scrollStates.setCanScrollLeft(selIndex > 0 || tb.canScrollPageBackwards());
        scrollStates.setCanScrollRight(selIndex >= 0 && selIndex < 7 && ((ITrack)tb.getItem(selIndex + 1)).doesExist() || tb.canScrollPageForwards());
        scrollStates.setCanScrollUp(sceneBank.canScrollPageBackwards());
        scrollStates.setCanScrollDown(sceneBank.canScrollPageForwards());
    }
}

