/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode.track;

import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameterprovider.special.ResetParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;

public class SLMkIIIVolumeMode
extends AbstractTrackMode {
    public SLMkIIIVolumeMode(SLMkIIIControlSurface surface, IModel model) {
        super("Volume", surface, model);
        VolumeParameterProvider parameterProvider = new VolumeParameterProvider(model);
        this.setParameterProvider(parameterProvider);
        this.setParameterProvider(ButtonID.DELETE, new ResetParameterProvider(parameterProvider));
    }

    @Override
    public void updateDisplay() {
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 8, "Volume");
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            if (t.doesExist()) {
                d.setCell(0, i, "Volume").setCell(1, i, t.getVolumeStr(9));
            }
            this.setColumnColors(d, i, t, 45);
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        d.setCell(1, 8, cursorTrack.doesExist() ? StringUtils.fixASCII(cursorTrack.getName(9)) : "");
        this.drawRow4();
        this.setButtonInfo(d);
        d.allDone();
    }

    @Override
    public int getModeColor() {
        return 45;
    }
}

