/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode.track;

import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.parameterprovider.special.ResetParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SelectedTrackParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;

public class SLMkIIITrackMode
extends AbstractTrackMode {
    public SLMkIIITrackMode(SLMkIIIControlSurface surface, IModel model) {
        super("Track", surface, model);
        SelectedTrackParameterProvider parameterProvider = new SelectedTrackParameterProvider(model);
        this.setParameterProvider(parameterProvider);
        this.setParameterProvider(ButtonID.DELETE, new ResetParameterProvider(parameterProvider));
    }

    @Override
    public void updateDisplay() {
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 8, "Track");
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            d.setBlock(1, 1, " Please  select a").setBlock(1, 2, "track.");
            d.setCell(1, 8, "");
            d.hideAllElements();
        } else {
            d.setCell(0, 0, "Volume").setCell(1, 0, cursorTrack.getVolumeStr(9));
            d.setPropertyColor(0, 0, 45);
            d.setPropertyColor(0, 1, 45);
            d.setCell(0, 1, "Pan").setCell(1, 1, cursorTrack.getPanStr(9));
            d.setPropertyColor(1, 0, 9);
            d.setPropertyColor(1, 1, 9);
            ISendBank sendBank = cursorTrack.getSendBank();
            for (int i = 0; i < 6; ++i) {
                ISend send;
                int pos = 2 + i;
                int color = 0;
                if (sendBank.getItemCount() > 0 && (send = (ISend)sendBank.getItem(i)).doesExist()) {
                    d.setCell(0, pos, send.getName(9)).setCell(1, pos, send.getDisplayedValue(9));
                    color = 13;
                }
                d.setPropertyColor(pos, 0, color);
                d.setPropertyColor(pos, 1, color);
            }
            d.setCell(1, 8, StringUtils.fixASCII(cursorTrack.getName(9)));
        }
        this.drawRow4();
        this.setButtonInfo(d);
        d.allDone();
    }

    @Override
    public int getModeColor() {
        return 21;
    }
}

