/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import java.util.Optional;

public class SendsView
extends AbstractFaderView {
    private int selectedSend;

    public SendsView(LaunchpadControlSurface surface, IModel model) {
        super("Sends", surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        ((ISend)((ITrack)this.model.getTrackBank().getItem(index)).getSendBank().getItem(this.selectedSend)).setValue(value);
    }

    @Override
    protected int getFaderValue(int index) {
        return ((ISend)((ITrack)this.model.getTrackBank().getItem(index)).getSendBank().getItem(this.selectedSend)).getValue();
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        this.selectedSend = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        ITrackBank tb = this.model.getTrackBank();
        String sendName = tb.getEditSendName(this.selectedSend);
        String message = "Send " + (this.selectedSend + 1) + ": " + (sendName.isEmpty() ? "None" : sendName);
        ((LaunchpadControlSurface)this.surface).getTextDisplay().notify(message);
    }

    @Override
    public void drawGrid() {
        for (int i = 0; i < 8; ++i) {
            this.setupFader(i);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int ordinal = buttonID.ordinal();
        if (ordinal < ButtonID.SCENE1.ordinal() || ordinal > ButtonID.SCENE8.ordinal()) {
            return 0;
        }
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (this.selectedSend == scene) {
            return 50;
        }
        ITrackBank tb = this.model.getTrackBank();
        if (tb.canEditSend(scene)) {
            return 1;
        }
        return 0;
    }

    public int getSelectedSend() {
        return this.selectedSend;
    }

    @Override
    public void setupFader(int index) {
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
        int color = this.colorManager.getColorIndex(DAWColor.getColorID(track.getColor()));
        ((LaunchpadControlSurface)this.surface).setupFader(index, color, false);
        ISend send = (ISend)track.getSendBank().getItem(this.selectedSend);
        ((LaunchpadControlSurface)this.surface).setFaderValue(index, send.getValue());
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional sel = tb.getSelectedItem();
        int selIndex = sel.isPresent() ? ((ITrack)sel.get()).getIndex() : -1;
        ISceneBank sceneBank = tb.getSceneBank();
        scrollStates.setCanScrollLeft(selIndex > 0 || tb.canScrollPageBackwards());
        scrollStates.setCanScrollRight(selIndex >= 0 && selIndex < 7 && ((ITrack)tb.getItem(selIndex + 1)).doesExist() || tb.canScrollPageForwards());
        scrollStates.setCanScrollUp(sceneBank.canScrollPageBackwards());
        scrollStates.setCanScrollDown(sceneBank.canScrollPageForwards());
    }
}

