/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.scale.Scales;

public class PlayControls {
    private static final int[] MODULATION_INTENSITIES = new int[]{0, 32, 64, 92, 127};
    private final LaunchpadControlSurface surface;
    private final Scales scales;
    private boolean isActive = false;
    private boolean isSustain = false;
    private boolean isPitchDown = false;
    private boolean isPitchUp = false;
    private int isModulation = 0;

    public PlayControls(LaunchpadControlSurface surface, Scales scales) {
        this.surface = surface;
        this.scales = scales;
    }

    public int getToggleButtonColor() {
        return this.isActive ? 21 : 23;
    }

    public void toggle() {
        this.isActive = !this.isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void draw() {
        if (!this.isActive) {
            return;
        }
        IPadGrid padGrid = this.surface.getPadGrid();
        int startNote = this.scales.getStartNote();
        padGrid.light(startNote, this.isSustain ? 13 : 15);
        padGrid.light(startNote + 1, this.isPitchDown ? 33 : 35);
        padGrid.light(startNote + 2, this.isPitchUp ? 33 : 35);
        for (int i = 0; i < 5; ++i) {
            padGrid.light(startNote + 3 + i, this.isModulation == i ? 53 : 55);
        }
    }

    public boolean handleGridNotes(int key, int velocity) {
        if (!this.isActive) {
            return false;
        }
        int pos = key - this.scales.getStartNote();
        if (pos >= 8) {
            return false;
        }
        boolean isDown = velocity > 0;
        IMidiInput midiInput = this.surface.getMidiInput();
        switch (pos) {
            case 0: {
                this.isSustain = isDown;
                midiInput.sendRawMidiEvent(176, 64, this.isSustain ? 127 : 0);
                break;
            }
            case 1: {
                this.isPitchDown = isDown;
                midiInput.sendRawMidiEvent(224, 0, this.isPitchDown ? Math.abs(velocity / 2 - 63) : 64);
                break;
            }
            case 2: {
                this.isPitchUp = isDown;
                midiInput.sendRawMidiEvent(224, 0, this.isPitchUp ? 64 + velocity / 2 : 64);
                break;
            }
            default: {
                if (!isDown) break;
                this.isModulation = pos - 3;
                midiInput.sendRawMidiEvent(176, 1, MODULATION_INTENSITIES[this.isModulation]);
            }
        }
        return true;
    }
}

