/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.PlayControls;
import de.mossgrabers.controller.novation.launchpad.view.PlayView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.PianoViewHelper;
import java.util.Arrays;

public class PianoView
extends PlayView {
    private final PlayControls playControls;

    public PianoView(LaunchpadControlSurface surface, IModel model) {
        super("Piano", surface, model);
        this.playControls = new PlayControls(surface, this.scales);
    }

    @Override
    public void drawGrid() {
        boolean isActive = this.playControls.isActive();
        PianoViewHelper.drawGrid(((LaunchpadControlSurface)this.surface).getPadGrid(), this.model, this.keyManager, isActive ? 44 : 36, isActive ? 7 : 8, 8);
        this.playControls.draw();
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.decPianoOctave();
        this.updateNoteMapping();
        ((LaunchpadControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText());
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.incPianoOctave();
        this.updateNoteMapping();
        ((LaunchpadControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText());
    }

    @Override
    protected int[] getMapping() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return EMPTY_TABLE;
        }
        int[] noteMatrix = this.scales.getPianoMatrix(8, 8);
        if (this.blockNotes > 0) {
            int startNote = this.scales.getStartNote();
            int endNote = this.scales.getEndNote();
            int length = endNote - startNote - this.blockNotes;
            System.arraycopy(noteMatrix, startNote, noteMatrix, startNote + this.blockNotes, length);
            Arrays.fill(noteMatrix, startNote, startNote + 8, -1);
        }
        return noteMatrix;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        if (buttonID == ButtonID.SCENE4) {
            this.playControls.toggle();
            this.setBlockedNotes(this.playControls.isActive() ? 8 : 0);
            this.updateNoteMapping();
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return buttonID == ButtonID.SCENE4 ? this.playControls.getToggleButtonColor() : 0;
    }

    @Override
    public void onGridNote(int key, int velocity) {
        if (!this.playControls.handleGridNotes(key, velocity)) {
            super.onGridNote(key, velocity);
        }
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        int pianoOctave = this.scales.getPianoOctave();
        scrollStates.setCanScrollLeft(false);
        scrollStates.setCanScrollRight(false);
        scrollStates.setCanScrollUp(pianoOctave < 3);
        scrollStates.setCanScrollDown(pianoOctave > -3);
    }
}

