/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.command.trigger;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SelectMainViewCommand
extends AbstractTriggerCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    private final Set<Views> allViewIds = new HashSet<Views>();

    public SelectMainViewCommand(IModel model, LaunchpadControlSurface surface, Collection<Views> allViewIds) {
        super(model, surface);
        this.allViewIds.addAll(allViewIds);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        IDisplay display = ((LaunchpadControlSurface)this.surface).getDisplay();
        if (viewManager.isActive(new Views[]{Views.CONTROL})) {
            viewManager.restore();
            display.notify(((IView)viewManager.getActive()).getName());
            return;
        }
        if (this.allViewIds.contains(viewManager.getActiveID())) {
            viewManager.setActive(Views.CONTROL);
            display.notify("Note / sequencer mode selection");
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            viewManager.setActive(Views.SESSION);
            display.notify("Session");
            return;
        }
        ((LaunchpadControlSurface)this.surface).recallPreferredView(this.model.getCursorTrack());
    }
}

