/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.controller;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3Display;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyPadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.DeviceInquiry;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.Views;
import java.util.HashMap;
import java.util.Map;

public class LaunchkeyMk3ControlSurface
extends AbstractControlSurface<LaunchkeyMk3Configuration> {
    public static final int LAUNCHKEY_25 = 52;
    public static final int LAUNCHKEY_37 = 53;
    public static final int LAUNCHKEY_49 = 54;
    public static final int LAUNCHKEY_61 = 55;
    public static final int LAUNCHKEY_88 = 64;
    public static final Map<Integer, String> LAUNCHKEY_MODEL_NAMES = new HashMap<Integer, String>(5);
    public static final int LAUNCHKEY_VIEW_SELECT = 3;
    public static final int LAUNCHKEY_MODE_SELECT = 9;
    public static final int LAUNCHKEY_FADER_SELECT = 10;
    public static final int LAUNCHKEY_TOUCH_EVENTS = 11;
    public static final int LAUNCHKEY_DAW_ONLINE = 12;
    public static final int LAUNCHKEY_KNOB_1 = 21;
    public static final int LAUNCHKEY_KNOB_2 = 22;
    public static final int LAUNCHKEY_KNOB_3 = 23;
    public static final int LAUNCHKEY_KNOB_4 = 24;
    public static final int LAUNCHKEY_KNOB_5 = 25;
    public static final int LAUNCHKEY_KNOB_6 = 26;
    public static final int LAUNCHKEY_KNOB_7 = 27;
    public static final int LAUNCHKEY_KNOB_8 = 28;
    public static final int LAUNCHKEY_SELECT1 = 37;
    public static final int LAUNCHKEY_SELECT2 = 38;
    public static final int LAUNCHKEY_SELECT3 = 39;
    public static final int LAUNCHKEY_SELECT4 = 40;
    public static final int LAUNCHKEY_SELECT5 = 41;
    public static final int LAUNCHKEY_SELECT6 = 42;
    public static final int LAUNCHKEY_SELECT7 = 43;
    public static final int LAUNCHKEY_SELECT8 = 44;
    public static final int LAUNCHKEY_TOGGLE_SELECT = 45;
    public static final int LAUNCHKEY_DEVICE_SELECT = 51;
    public static final int LAUNCHKEY_DEVICE_LOCK = 52;
    public static final int LAUNCHKEY_FADER_1 = 53;
    public static final int LAUNCHKEY_FADER_2 = 54;
    public static final int LAUNCHKEY_FADER_3 = 55;
    public static final int LAUNCHKEY_FADER_4 = 56;
    public static final int LAUNCHKEY_FADER_5 = 57;
    public static final int LAUNCHKEY_FADER_6 = 58;
    public static final int LAUNCHKEY_FADER_7 = 59;
    public static final int LAUNCHKEY_FADER_8 = 60;
    public static final int LAUNCHKEY_FADER_MASTER = 61;
    public static final int LAUNCHKEY_CAPTURE_MIDI = 74;
    public static final int LAUNCHKEY_QUANTIZE = 75;
    public static final int LAUNCHKEY_CLICK = 76;
    public static final int LAUNCHKEY_UNDO = 77;
    public static final int LAUNCHKEY_TRACK_RIGHT = 102;
    public static final int LAUNCHKEY_TRACK_LEFT = 103;
    public static final int LAUNCHKEY_SCENE1 = 104;
    public static final int LAUNCHKEY_SCENE2 = 105;
    public static final int LAUNCHKEY_ARROW_UP = 106;
    public static final int LAUNCHKEY_ARROW_DOWN = 107;
    public static final int LAUNCHKEY_SHIFT = 108;
    public static final int LAUNCHKEY_PLAY = 115;
    public static final int LAUNCHKEY_STOP = 116;
    public static final int LAUNCHKEY_RECORD = 117;
    public static final int LAUNCHKEY_LOOP = 118;
    public static final int FADER_MODE_CUSTOM = 0;
    public static final int FADER_MODE_VOLUME = 1;
    public static final int FADER_MODE_PARAMS = 2;
    public static final int FADER_MODE_SEND1 = 4;
    public static final int FADER_MODE_SEND2 = 5;
    public static final int FADER_MODE_CUSTOM1 = 6;
    public static final int FADER_MODE_CUSTOM2 = 7;
    public static final int FADER_MODE_CUSTOM3 = 8;
    public static final int FADER_MODE_CUSTOM4 = 9;
    public static final int KNOB_MODE_CUSTOM = 0;
    public static final int KNOB_MODE_VOLUME = 1;
    public static final int KNOB_MODE_PARAMS = 2;
    public static final int KNOB_MODE_PAN = 3;
    public static final int KNOB_MODE_SEND1 = 4;
    public static final int KNOB_MODE_SEND2 = 5;
    public static final int KNOB_MODE_CUSTOM1 = 6;
    public static final int KNOB_MODE_CUSTOM2 = 7;
    public static final int KNOB_MODE_CUSTOM3 = 8;
    public static final int KNOB_MODE_CUSTOM4 = 9;
    public static final int PAD_MODE_CUSTOM = 0;
    public static final int PAD_MODE_DRUM = 1;
    public static final int PAD_MODE_SESSION = 2;
    public static final int PAD_MODE_SCALE_CHORDS = 3;
    public static final int PAD_MODE_USER_CHORDS = 4;
    public static final int PAD_MODE_CUSTOM_MODE0 = 5;
    public static final int PAD_MODE_CUSTOM_MODE1 = 6;
    public static final int PAD_MODE_CUSTOM_MODE2 = 7;
    public static final int PAD_MODE_CUSTOM_MODE3 = 8;
    public static final int PAD_MODE_DEVICE_SELECT = 9;
    public static final int PAD_MODE_NAVIGATION = 10;
    private final ModeManager faderModeManager = new ModeManager();
    private boolean isDAWConnected = false;
    private boolean hasFaders = true;

    public LaunchkeyMk3ControlSurface(IHost host, ColorManager colorManager, LaunchkeyMk3Configuration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, new LaunchkeyPadGrid(colorManager, output), 1400.0, 600.0);
        this.input.setSysexCallback(this::handleSysEx);
        this.output.sendSysex(new byte[][]{DeviceInquiry.createQuery()});
    }

    @Override
    protected void createPads() {
        ((LaunchkeyPadGrid)this.padGrid).setView(Views.SESSION);
        super.createPads();
        int size = this.padGrid.getRows() * this.padGrid.getCols();
        int startNote = this.padGrid.getStartNote();
        for (int i = 0; i < size; ++i) {
            int note = startNote + i;
            ButtonID buttonID = ButtonID.get(ButtonID.PAD17, i);
            IHwButton pad = this.createButton(buttonID, "D " + (i + 1));
            pad.addLight(this.surfaceFactory.createLight(this.surfaceID, null, () -> this.padGrid.getLightInfo(note).getEncoded(), state -> this.padGrid.sendState(note), colorIndex -> this.colorManager.getColor(colorIndex, buttonID), null));
            int[] translated = LaunchkeyPadGrid.translateToController(Views.DRUM, note);
            pad.bind(this.input, BindType.NOTE, translated[0], translated[1]);
            pad.bind((event, velocity) -> this.handleGridNote(event, note, velocity));
            ButtonID buttonID2 = ButtonID.get(ButtonID.PAD33, i);
            pad = this.createButton(buttonID2, "DS " + (i + 1));
            pad.addLight(this.surfaceFactory.createLight(this.surfaceID, null, () -> this.padGrid.getLightInfo(note).getEncoded(), state -> this.padGrid.sendState(note), colorIndex -> this.colorManager.getColor(colorIndex, buttonID2), null));
            translated = LaunchkeyPadGrid.translateToController(Views.DEVICE, note);
            pad.bind(this.input, BindType.NOTE, translated[0], translated[1]);
            pad.bind((event, velocity) -> this.handleGridNote(event, note, velocity));
        }
    }

    public ModeManager getFaderModeManager() {
        return this.faderModeManager;
    }

    @Override
    protected void updateViewControls() {
        IMode m;
        super.updateViewControls();
        if (this.hasFaders() && (m = (IMode)this.faderModeManager.getActive()) != null) {
            m.updateDisplay();
        }
    }

    @Override
    protected void internalShutdown() {
        this.setLaunchpadToDAW(false);
    }

    public void setLaunchpadToDAW(boolean enable) {
        this.output.sendNoteEx(15, 12, enable ? 127 : 0);
    }

    @Override
    public LaunchkeyPadGrid getPadGrid() {
        return (LaunchkeyPadGrid)super.getPadGrid();
    }

    public void setKnobMode(int knobMode) {
        this.output.sendCCEx(15, 9, knobMode);
    }

    public void setPadMode(int padMode) {
        this.output.sendCCEx(15, 3, padMode);
    }

    public boolean isDAWConnected() {
        return this.isDAWConnected;
    }

    public void setDAWConnected(boolean isDAWConnected) {
        this.isDAWConnected = isDAWConnected;
    }

    public boolean hasFaders() {
        return this.hasFaders;
    }

    private void handleSysEx(String data) {
        int[] byteData = StringUtils.fromHexStr(data);
        DeviceInquiry deviceInquiry = new DeviceInquiry(byteData);
        if (deviceInquiry.isValid()) {
            this.handleDeviceInquiryResponse(deviceInquiry);
        }
    }

    private void handleDeviceInquiryResponse(DeviceInquiry deviceInquiry) {
        int[] revisionLevel = deviceInquiry.getRevisionLevel();
        String firmwareVersion = String.format("%d%d%d%d", revisionLevel[0], revisionLevel[1], revisionLevel[2], revisionLevel[3]);
        int deviceFamilyCode = deviceInquiry.getDeviceFamilyCode()[0];
        this.hasFaders = deviceFamilyCode >= 54;
        IDisplay iDisplay = this.getDisplay();
        if (iDisplay instanceof LaunchkeyMk3Display) {
            LaunchkeyMk3Display launchkeyDisplay = (LaunchkeyMk3Display)iDisplay;
            launchkeyDisplay.setModel(deviceFamilyCode == 64);
        }
        this.host.println("Detected " + LAUNCHKEY_MODEL_NAMES.get(deviceFamilyCode) + " (Firmware version: " + (firmwareVersion.charAt(0) == '0' ? firmwareVersion.substring(1) : firmwareVersion) + ")");
    }

    static {
        LAUNCHKEY_MODEL_NAMES.put(52, "Launchkey 25");
        LAUNCHKEY_MODEL_NAMES.put(53, "Launchkey 37");
        LAUNCHKEY_MODEL_NAMES.put(54, "Launchkey 49");
        LAUNCHKEY_MODEL_NAMES.put(55, "Launchkey 61");
        LAUNCHKEY_MODEL_NAMES.put(64, "Launchkey 88");
    }
}

