/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.command.trigger;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.track.RecArmCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ButtonAreaCommand
extends AbstractTriggerCommand<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    private static boolean isSelect = true;
    private final int column;
    private final TriggerCommand recArmCommand;

    public ButtonAreaCommand(int column, IModel model, LaunchkeyMk3ControlSurface surface) {
        super(model, surface);
        this.column = column;
        this.recArmCommand = new RecArmCommand(column, model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (((LaunchkeyMk3ControlSurface)this.surface).isPressed(ButtonID.UNDO)) {
            if (event == ButtonEvent.DOWN) {
                this.getColumnTrack().remove();
                ((LaunchkeyMk3ControlSurface)this.surface).setTriggerConsumed(ButtonID.UNDO);
            }
            return;
        }
        if (isSelect) {
            if (event == ButtonEvent.DOWN) {
                this.getColumnTrack().selectOrExpandGroup();
            }
        } else {
            this.recArmCommand.execute(event, velocity);
        }
    }

    public int getButtonColor() {
        ITrack t = this.getColumnTrack();
        int color = !t.doesExist() ? 0 : (isSelect ? this.model.getColorManager().getColorIndex(DAWColor.getColorID(t.getColor())) : (t.isRecArm() ? 6 : 1));
        return t.isSelected() ? 4096 + color : color;
    }

    private ITrack getColumnTrack() {
        return (ITrack)this.model.getCurrentTrackBank().getItem(this.column);
    }

    public static void toggleSelect() {
        isSelect = !isSelect;
    }

    public static boolean isSelect() {
        return isSelect;
    }
}

