/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.controller;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;

public class LaunchControlXLControlSurface
extends AbstractControlSurface<LaunchControlXLConfiguration> {
    public static final int LAUNCHCONTROL_KNOB_SEND_A_1 = 13;
    public static final int LAUNCHCONTROL_KNOB_SEND_A_2 = 14;
    public static final int LAUNCHCONTROL_KNOB_SEND_A_3 = 15;
    public static final int LAUNCHCONTROL_KNOB_SEND_A_4 = 16;
    public static final int LAUNCHCONTROL_KNOB_SEND_A_5 = 17;
    public static final int LAUNCHCONTROL_KNOB_SEND_A_6 = 18;
    public static final int LAUNCHCONTROL_KNOB_SEND_A_7 = 19;
    public static final int LAUNCHCONTROL_KNOB_SEND_A_8 = 20;
    public static final int LAUNCHCONTROL_KNOB_SEND_B_1 = 29;
    public static final int LAUNCHCONTROL_KNOB_SEND_B_2 = 30;
    public static final int LAUNCHCONTROL_KNOB_SEND_B_3 = 31;
    public static final int LAUNCHCONTROL_KNOB_SEND_B_4 = 32;
    public static final int LAUNCHCONTROL_KNOB_SEND_B_5 = 33;
    public static final int LAUNCHCONTROL_KNOB_SEND_B_6 = 34;
    public static final int LAUNCHCONTROL_KNOB_SEND_B_7 = 35;
    public static final int LAUNCHCONTROL_KNOB_SEND_B_8 = 36;
    public static final int LAUNCHCONTROL_KNOB_PAN_1 = 49;
    public static final int LAUNCHCONTROL_KNOB_PAN_2 = 50;
    public static final int LAUNCHCONTROL_KNOB_PAN_3 = 51;
    public static final int LAUNCHCONTROL_KNOB_PAN_4 = 52;
    public static final int LAUNCHCONTROL_KNOB_PAN_5 = 53;
    public static final int LAUNCHCONTROL_KNOB_PAN_6 = 54;
    public static final int LAUNCHCONTROL_KNOB_PAN_7 = 55;
    public static final int LAUNCHCONTROL_KNOB_PAN_8 = 56;
    public static final int LAUNCHCONTROL_FADER_1 = 77;
    public static final int LAUNCHCONTROL_FADER_2 = 78;
    public static final int LAUNCHCONTROL_FADER_3 = 79;
    public static final int LAUNCHCONTROL_FADER_4 = 80;
    public static final int LAUNCHCONTROL_FADER_5 = 81;
    public static final int LAUNCHCONTROL_FADER_6 = 82;
    public static final int LAUNCHCONTROL_FADER_7 = 83;
    public static final int LAUNCHCONTROL_FADER_8 = 84;
    public static final int LAUNCHCONTROL_SEND_PREV = 104;
    public static final int LAUNCHCONTROL_SEND_NEXT = 105;
    public static final int LAUNCHCONTROL_TRACK_PREV = 106;
    public static final int LAUNCHCONTROL_TRACK_NEXT = 107;
    public static final int LAUNCHCONTROL_DEVICE = 105;
    public static final int LAUNCHCONTROL_MUTE = 106;
    public static final int LAUNCHCONTROL_SOLO = 107;
    public static final int LAUNCHCONTROL_RECORD_ARM = 108;
    public static final int LAUNCHCONTROL_TRACK_FOCUS_1 = 41;
    public static final int LAUNCHCONTROL_TRACK_FOCUS_2 = 42;
    public static final int LAUNCHCONTROL_TRACK_FOCUS_3 = 43;
    public static final int LAUNCHCONTROL_TRACK_FOCUS_4 = 44;
    public static final int LAUNCHCONTROL_TRACK_FOCUS_5 = 57;
    public static final int LAUNCHCONTROL_TRACK_FOCUS_6 = 58;
    public static final int LAUNCHCONTROL_TRACK_FOCUS_7 = 59;
    public static final int LAUNCHCONTROL_TRACK_FOCUS_8 = 60;
    public static final int LAUNCHCONTROL_TRACK_CONTROL_1 = 73;
    public static final int LAUNCHCONTROL_TRACK_CONTROL_2 = 74;
    public static final int LAUNCHCONTROL_TRACK_CONTROL_3 = 75;
    public static final int LAUNCHCONTROL_TRACK_CONTROL_4 = 76;
    public static final int LAUNCHCONTROL_TRACK_CONTROL_5 = 89;
    public static final int LAUNCHCONTROL_TRACK_CONTROL_6 = 90;
    public static final int LAUNCHCONTROL_TRACK_CONTROL_7 = 91;
    public static final int LAUNCHCONTROL_TRACK_CONTROL_8 = 92;
    private static final int[] TEMPLATE_CHANGE_HEADER = new int[]{240, 0, 32, 41, 2, 17, 119};
    private final ModeManager trackButtonModeManager = new ModeManager();
    private final ModeManager faderModeManager = new ModeManager();

    public LaunchControlXLControlSurface(IHost host, ColorManager colorManager, LaunchControlXLConfiguration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, null, 650.0, 450.0);
        this.input.setSysexCallback(this::handleSysEx);
    }

    public ModeManager getTrackButtonModeManager() {
        return this.trackButtonModeManager;
    }

    public ModeManager getFaderModeManager() {
        return this.faderModeManager;
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int noteOrCC, int state) {
        if (bindType == BindType.NOTE) {
            this.output.sendNoteEx(channel, noteOrCC, state);
        } else {
            this.output.sendCCEx(channel, noteOrCC, state);
        }
    }

    @Override
    protected void handleCC(int channel, int data1, int data2) {
    }

    public void setKnobLEDColor(int row, int column, int green, int red) {
        int midiChannel = ((LaunchControlXLConfiguration)this.configuration).getTemplate();
        if (midiChannel >= 8) {
            this.setKnobLED(midiChannel, 13 + row + column * 16, green, red);
        }
    }

    private void setKnobLED(int channel, int note, int green, int red) {
        int g = Math.min(3, Math.max(0, green));
        int r = Math.min(3, Math.max(0, red));
        this.output.sendNoteEx(channel, note, 12 + r + (g << 4));
    }

    private void handleSysEx(String data) {
        int[] byteData = StringUtils.fromHexStr(data);
        if (byteData.length == 9 && Arrays.equals(byteData, 0, TEMPLATE_CHANGE_HEADER.length, TEMPLATE_CHANGE_HEADER, 0, TEMPLATE_CHANGE_HEADER.length)) {
            int templateID = byteData[7];
            if (((LaunchControlXLConfiguration)this.configuration).getTemplate() == templateID) {
                return;
            }
            ((LaunchControlXLConfiguration)this.configuration).setTemplate(templateID);
            return;
        }
        this.errorln("Unhandled Sysex: " + data);
    }

    public void selectTemplate(int templateID) {
        byte[] data = new byte[TEMPLATE_CHANGE_HEADER.length + 2];
        for (int i = 0; i < TEMPLATE_CHANGE_HEADER.length; ++i) {
            data[i] = (byte)TEMPLATE_CHANGE_HEADER[i];
        }
        data[data.length - 2] = (byte)templateID;
        data[data.length - 1] = -9;
        this.output.sendSysex(new byte[][]{data});
    }
}

