/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.KeyboardCommand;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.DrumView;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class PadModeCommand
extends AbstractTriggerCommand<MaschineControlSurface, MaschineConfiguration> {
    private final KeyboardCommand keyboardCommand;

    public PadModeCommand(KeyboardCommand keyboardCommand, IModel model, MaschineControlSurface surface) {
        super(model, surface);
        this.keyboardCommand = keyboardCommand;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((MaschineControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.DRUM})) {
            if (!((MaschineControlSurface)this.surface).getMaschine().hasMCUDisplay()) {
                ((DrumView)viewManager.get(Views.DRUM)).toggleShifted();
            }
            ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
            if (modeManager.isActive(new Modes[]{Modes.PLAY_OPTIONS})) {
                modeManager.restore();
            } else {
                modeManager.setActive(Modes.PLAY_OPTIONS);
            }
        } else {
            viewManager.setActive(Views.DRUM);
            ((INoteEditorMode)((MaschineControlSurface)this.surface).getModeManager().get(Modes.NOTE)).getNoteEditor().clearNotes();
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            if (cursorTrack.doesExist()) {
                viewManager.setPreferredView(cursorTrack.getPosition(), Views.DRUM);
            }
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        ((MaschineControlSurface)this.surface).setStopConsumed();
        this.keyboardCommand.executeNormal(event);
    }
}

