/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.controller;

import de.mossgrabers.controller.ni.kontrol.mkii.controller.IKontrolProtocolDeviceDescriptor;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class KontrolProtocolDeviceDescriptorV1
implements IKontrolProtocolDeviceDescriptor {
    private static final String KOMPLETE_KONTROL_A_DAW = "Komplete Kontrol A DAW";
    private static final UUID EXTENSION_ID = UUID.fromString("4EA6215E-C7EB-4184-AEA4-67D03D8EF7A8");
    private static final String DEVICE_NAME = "Komplete Kontrol A-series / M32";
    private static final String[][] PORTS_WINDOWS = new String[][]{{"Komplete Kontrol A DAW", "KOMPLETE KONTROL A25 MIDI"}, {"Komplete Kontrol A DAW", "KOMPLETE KONTROL A49 MIDI"}, {"Komplete Kontrol A DAW", "KOMPLETE KONTROL A61 MIDI"}, {"Komplete Kontrol M DAW", "KOMPLETE KONTROL M32 MIDI"}};
    private static final String[][] PORTS_MACOS = new String[][]{{"Komplete Kontrol A DAW", "KOMPLETE KONTROL A25"}, {"Komplete Kontrol A DAW", "KOMPLETE KONTROL A49"}, {"Komplete Kontrol A DAW", "KOMPLETE KONTROL A61"}, {"Komplete Kontrol M DAW", "KOMPLETE KONTROL M32"}};

    @Override
    public UUID getID() {
        return EXTENSION_ID;
    }

    @Override
    public String getName() {
        return DEVICE_NAME;
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        ArrayList<Pair<String[], String[]>> midiDiscoveryPairs = new ArrayList<Pair<String[], String[]>>();
        for (String[] ports : switch (os) {
            case OperatingSystem.MAC, OperatingSystem.MAC_ARM -> PORTS_MACOS;
            case OperatingSystem.WINDOWS -> PORTS_WINDOWS;
            default -> new String[0][0];
        }) {
            midiDiscoveryPairs.add(new Pair<String[], String[]>(ports, ports));
        }
        return midiDiscoveryPairs;
    }
}

