/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.controller;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public class MCUControlSurface
extends AbstractControlSurface<MCUConfiguration> {
    public static final int MCU_ARM1 = 0;
    public static final int MCU_ARM2 = 1;
    public static final int MCU_ARM3 = 2;
    public static final int MCU_ARM4 = 3;
    public static final int MCU_ARM5 = 4;
    public static final int MCU_ARM6 = 5;
    public static final int MCU_ARM7 = 6;
    public static final int MCU_ARM8 = 7;
    public static final int MCU_SOLO1 = 8;
    public static final int MCU_SOLO2 = 9;
    public static final int MCU_SOLO3 = 10;
    public static final int MCU_SOLO4 = 11;
    public static final int MCU_SOLO5 = 12;
    public static final int MCU_SOLO6 = 13;
    public static final int MCU_SOLO7 = 14;
    public static final int MCU_SOLO8 = 15;
    public static final int MCU_MUTE1 = 16;
    public static final int MCU_MUTE2 = 17;
    public static final int MCU_MUTE3 = 18;
    public static final int MCU_MUTE4 = 19;
    public static final int MCU_MUTE5 = 20;
    public static final int MCU_MUTE6 = 21;
    public static final int MCU_MUTE7 = 22;
    public static final int MCU_MUTE8 = 23;
    public static final int MCU_SELECT1 = 24;
    public static final int MCU_SELECT2 = 25;
    public static final int MCU_SELECT3 = 26;
    public static final int MCU_SELECT4 = 27;
    public static final int MCU_SELECT5 = 28;
    public static final int MCU_SELECT6 = 29;
    public static final int MCU_SELECT7 = 30;
    public static final int MCU_SELECT8 = 31;
    public static final int MCU_VSELECT1 = 32;
    public static final int MCU_VSELECT2 = 33;
    public static final int MCU_VSELECT3 = 34;
    public static final int MCU_VSELECT4 = 35;
    public static final int MCU_VSELECT5 = 36;
    public static final int MCU_VSELECT6 = 37;
    public static final int MCU_VSELECT7 = 38;
    public static final int MCU_VSELECT8 = 39;
    public static final int MCU_MODE_IO = 40;
    public static final int MCU_MODE_SENDS = 41;
    public static final int MCU_MODE_PAN = 42;
    public static final int MCU_MODE_PLUGIN = 43;
    public static final int MCU_MODE_EQ = 44;
    public static final int MCU_MODE_DYN = 45;
    public static final int MCU_BANK_LEFT = 46;
    public static final int MCU_BANK_RIGHT = 47;
    public static final int MCU_TRACK_LEFT = 48;
    public static final int MCU_TRACK_RIGHT = 49;
    public static final int MCU_FLIP = 50;
    public static final int MCU_EDIT = 51;
    public static final int MCU_NAME_VALUE = 52;
    public static final int MCU_SMPTE_BEATS = 53;
    public static final int MCU_F1 = 54;
    public static final int MCU_F2 = 55;
    public static final int MCU_F3 = 56;
    public static final int MCU_F4 = 57;
    public static final int MCU_F5 = 58;
    public static final int MCU_F6 = 59;
    public static final int MCU_F7 = 60;
    public static final int MCU_F8 = 61;
    public static final int MCU_MIDI_TRACKS = 62;
    public static final int MCU_INPUTS = 63;
    public static final int MCU_AUDIO_TRACKS = 64;
    public static final int MCU_AUDIO_INSTR = 65;
    public static final int MCU_AUX = 66;
    public static final int MCU_BUSSES = 67;
    public static final int MCU_OUTPUTS = 68;
    public static final int MCU_USER = 69;
    public static final int MCU_SHIFT = 70;
    public static final int MCU_OPTION = 71;
    public static final int MCU_CONTROL = 72;
    public static final int MCU_ALT = 73;
    public static final int MCU_READ = 74;
    public static final int MCU_WRITE = 75;
    public static final int MCU_TRIM = 76;
    public static final int MCU_TOUCH = 77;
    public static final int MCU_LATCH = 78;
    public static final int MCU_GROUP = 79;
    public static final int MCU_SAVE = 80;
    public static final int MCU_UNDO = 81;
    public static final int MCU_CANCEL = 82;
    public static final int MCU_ENTER = 83;
    public static final int MCU_MARKER = 84;
    public static final int MCU_NUDGE = 85;
    public static final int MCU_REPEAT = 86;
    public static final int MCU_DROP = 87;
    public static final int MCU_REPLACE = 88;
    public static final int MCU_CLICK = 89;
    public static final int MCU_SOLO = 90;
    public static final int MCU_REWIND = 91;
    public static final int MCU_FORWARD = 92;
    public static final int MCU_STOP = 93;
    public static final int MCU_PLAY = 94;
    public static final int MCU_RECORD = 95;
    public static final int MCU_ARROW_UP = 96;
    public static final int MCU_ARROW_DOWN = 97;
    public static final int MCU_ARROW_LEFT = 98;
    public static final int MCU_ARROW_RIGHT = 99;
    public static final int MCU_ZOOM = 100;
    public static final int MCU_SCRUB = 101;
    public static final int MCU_USER_A = 102;
    public static final int MCU_USER_B = 103;
    public static final int MCU_FADER_TOUCH1 = 104;
    public static final int MCU_FADER_TOUCH2 = 105;
    public static final int MCU_FADER_TOUCH3 = 106;
    public static final int MCU_FADER_TOUCH4 = 107;
    public static final int MCU_FADER_TOUCH5 = 108;
    public static final int MCU_FADER_TOUCH6 = 109;
    public static final int MCU_FADER_TOUCH7 = 110;
    public static final int MCU_FADER_TOUCH8 = 111;
    public static final int MCU_FADER_MASTER = 112;
    public static final int MCU_SMPTE_LED = 113;
    public static final int MCU_BEATS_LED = 114;
    public static final int MCU_RUDE_SOLO_L = 115;
    public static final int MCU_RELAY_CLICK = 118;
    public static final int MCU_CC_VPOT1 = 16;
    public static final int MCU_CC_VPOT2 = 17;
    public static final int MCU_CC_VPOT3 = 18;
    public static final int MCU_CC_VPOT4 = 19;
    public static final int MCU_CC_VPOT5 = 20;
    public static final int MCU_CC_VPOT6 = 21;
    public static final int MCU_CC_VPOT7 = 22;
    public static final int MCU_CC_VPOT8 = 23;
    public static final int MCU_CC_JOG = 60;
    public static final String SYSEX_HDR = "F0 00 00 66 14 ";
    public static final int MCU_SYSEX_CMD_DISPLAY = 18;
    private static final boolean[] MCU_BUTTON_UPDATE = new boolean[128];
    public static final int VUMODE_LED = 1;
    public static final int VUMODE_OFF = 2;
    public static final int VUMODE_LED_AND_LCD = 3;
    public static final int VUMODE_LCD = 4;
    public static final int KNOB_LED_MODE_SINGLE_DOT = 0;
    public static final int KNOB_LED_MODE_BOOST_CUT = 1;
    public static final int KNOB_LED_MODE_WRAP = 2;
    public static final int KNOB_LED_MODE_SPREAD = 3;
    private int activeVuMode = 1;
    private final int[] knobValues = new int[8];
    private byte[] currentColors = new byte[8];
    private final int[][] currentAsparionColors = new int[8][3];
    private final List<MCUControlSurface> surfaces;
    private final int extenderOffset;
    private final boolean isMainDevice;
    private int[] itemIndices = new int[0];

    public MCUControlSurface(List<MCUControlSurface> surfaces, IHost host, ColorManager colorManager, MCUConfiguration configuration, IMidiOutput output, IMidiInput input, int extenderOffset, boolean isMainDevice) {
        super(surfaces.size(), host, configuration, colorManager, output, input, null, isMainDevice ? 1000.0 : 600.0, 1000.0);
        this.surfaces = surfaces;
        this.extenderOffset = extenderOffset;
        this.isMainDevice = isMainDevice;
        Arrays.fill(this.knobValues, -1);
        Arrays.fill(this.currentColors, (byte)-1);
        for (int i = 0; i < 8; ++i) {
            Arrays.fill(this.currentAsparionColors[i], -1);
        }
    }

    @Override
    protected void internalShutdown() {
        IMidiOutput output = this.getMidiOutput();
        for (int i = 0; i < 8; ++i) {
            output.sendChannelAftertouch(16 * i, 0);
            output.sendPitchbend(i, 0, 0);
        }
        output.sendChannelAftertouch(1, 0, 0);
        output.sendChannelAftertouch(1, 16, 0);
        output.sendPitchbend(8, 0, 0);
        int[] values = new int[8];
        Arrays.fill(values, 0);
        this.setItemIndices(values);
        for (int i = 0; i < 8; ++i) {
            this.setKnobLED(i, 0, 0, 127);
        }
        boolean isAsparion = ((MCUConfiguration)this.configuration).hasDisplayColors() == MCUConfiguration.DisplayColors.ASPARION;
        ColorEx[] colors = new ColorEx[8];
        for (int i = 0; i < 8; ++i) {
            colors[i] = isAsparion ? ColorEx.BLACK : ColorEx.WHITE;
        }
        this.sendDisplayColor(colors);
        super.internalShutdown();
    }

    public boolean shouldUpdateButton(int button) {
        return MCU_BUTTON_UPDATE[button];
    }

    public void setKnobLED(int index, int knobLEDMode, int value, int maxValue) {
        boolean isAsparion;
        int v = 0;
        boolean bl = isAsparion = ((MCUConfiguration)this.configuration).hasDisplayColors() == MCUConfiguration.DisplayColors.ASPARION;
        if (isAsparion) {
            v = (int)Math.round((double)value * 127.0 / (double)maxValue);
        } else {
            int rescale = (int)Math.round((double)value * 11.0 / (double)maxValue);
            if (value > 0 && rescale == 0) {
                rescale = 1;
            }
            v = knobLEDMode << 4;
            v += rescale;
        }
        if (this.knobValues[index] == v) {
            return;
        }
        this.knobValues[index] = v;
        if (isAsparion) {
            this.output.sendCCEx(knobLEDMode == 1 ? 2 : 1, 48 + index, v);
        } else {
            this.output.sendCC(48 + index, v);
        }
    }

    public void setItemIndices(int[] values) {
        if (((MCUConfiguration)this.configuration).getMainDisplayType() != MCUConfiguration.MainDisplay.ASPARION || Arrays.compare(this.itemIndices, values) == 0) {
            return;
        }
        this.itemIndices = values;
        StringBuilder msg = new StringBuilder(SYSEX_HDR).append("17 00 ");
        for (int itemIndex : this.itemIndices) {
            msg.append(StringUtils.toHexStr(itemIndex % 128)).append(' ');
        }
        this.output.sendSysex(msg.append("F7").toString());
    }

    public int getExtenderOffset() {
        return this.extenderOffset;
    }

    public void switchVuMode(int mode) {
        this.output.sendSysex(SYSEX_HDR + "21 00 F7");
        if (this.activeVuMode != mode) {
            this.activeVuMode = this.activeVuMode < 5 ? mode : 1;
        }
        IMidiOutput out = this.getMidiOutput();
        switch (this.activeVuMode) {
            case 1: {
                for (int i = 0; i < 8; ++i) {
                    out.sendChannelAftertouch(0 + (i << 4), 0);
                    out.sendSysex("F0 00 00 66 14 20 0" + i + " 01 F7");
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 8; ++i) {
                    out.sendChannelAftertouch(0 + (i << 4), 0);
                    out.sendSysex("F0 00 00 66 14 20 0" + i + " 03 F7");
                }
                break;
            }
            case 4: {
                for (int i = 0; i < 8; ++i) {
                    out.sendChannelAftertouch(0 + (i << 4), 0);
                    out.sendSysex("F0 00 00 66 14 20 0" + i + " 06 F7");
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 8; ++i) {
                    out.sendChannelAftertouch(0 + (i << 4), 0);
                    out.sendSysex("F0 00 00 66 14 20 0" + i + " 00 F7");
                }
                break;
            }
        }
    }

    public void sendDisplayColor(ColorEx[] colors) {
        IMidiOutput midiOutput = this.getMidiOutput();
        switch (((MCUConfiguration)this.configuration).hasDisplayColors()) {
            case BEHRINGER: {
                Object[] cs = colors;
                if (this.isMainDevice && this.getTextDisplay().isNotificationActive()) {
                    cs = new ColorEx[8];
                    Arrays.fill(cs, ColorEx.WHITE);
                }
                byte[] displayColors = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    displayColors[i] = MCUControlSurface.toIndex((ColorEx)(cs[i] == null ? ColorEx.BLACK : cs[i]));
                }
                if (Arrays.compare(displayColors, this.currentColors) == 0) {
                    return;
                }
                this.currentColors = displayColors;
                byte[] msg1 = new byte[15];
                msg1[0] = -16;
                msg1[1] = 0;
                msg1[2] = 0;
                msg1[3] = 102;
                msg1[4] = this.isMainDevice ? 20 : 21;
                msg1[5] = 114;
                for (int i = 0; i < 8; ++i) {
                    msg1[6 + i] = displayColors[i];
                }
                msg1[14] = -9;
                midiOutput.sendSysex(new byte[][]{msg1});
                break;
            }
            case ICON: {
                byte[] msg2 = new byte[31];
                msg2[0] = -16;
                msg2[1] = 0;
                msg2[2] = 2;
                msg2[3] = 78;
                msg2[4] = 22;
                msg2[5] = 20;
                for (int i = 0; i < 8; ++i) {
                    int[] rgb = colors[i].toIntRGB127();
                    msg2[6 + 3 * i + 0] = (byte)rgb[0];
                    msg2[6 + 3 * i + 1] = (byte)rgb[1];
                    msg2[6 + 3 * i + 2] = (byte)rgb[2];
                }
                msg2[30] = -9;
                if (Arrays.compare(msg2, this.currentColors) == 0) {
                    return;
                }
                this.currentColors = msg2;
                midiOutput.sendSysex(new byte[][]{msg2});
                break;
            }
            case ASPARION: {
                for (int i = 0; i < 8; ++i) {
                    int[] rgb = colors[i].toIntRGB127();
                    if (Arrays.compare(rgb, this.currentAsparionColors[i]) == 0) {
                        return;
                    }
                    this.currentAsparionColors[i] = rgb;
                    int note = 32 + i;
                    midiOutput.sendNoteEx(1, note, rgb[0]);
                    midiOutput.sendNoteEx(2, note, rgb[1]);
                    midiOutput.sendNoteEx(3, note, rgb[2]);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private static byte toIndex(ColorEx color) {
        double red = color.getRed();
        double green = color.getGreen();
        double blue = color.getBlue();
        if (red < 0.5 && green < 0.5 && blue < 0.5 && (red > 0.0 || green > 0.0 || blue > 0.0)) {
            return 7;
        }
        int hasRed = red >= 0.5 ? 1 : 0;
        int hasGreen = green >= 0.5 ? 1 : 0;
        int hasBlue = blue >= 0.5 ? 1 : 0;
        return (byte)(hasBlue * 4 + hasGreen * 2 + hasRed);
    }

    @Override
    public boolean isPressed(ButtonID buttonID) {
        for (MCUControlSurface surface : this.surfaces) {
            if (!surface.isSinglePressed(buttonID)) continue;
            return true;
        }
        return false;
    }

    private boolean isSinglePressed(ButtonID buttonID) {
        return super.isPressed(buttonID);
    }

    public boolean isLastDevice() {
        return this.surfaceID == this.surfaces.size() - 1;
    }

    public boolean isMainDevice() {
        return this.isMainDevice;
    }

    static {
        Arrays.fill(MCU_BUTTON_UPDATE, false);
    }
}

