/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.Arrays;
import java.util.List;

public class HUIConfiguration
extends AbstractConfiguration {
    public static final Integer ZOOM_STATE = 100;
    public static final Integer HAS_DISPLAY1 = 101;
    public static final Integer SEND_PING = 102;
    public static final Integer HAS_SEGMENT_DISPLAY = 103;
    public static final Integer HAS_MOTOR_FADERS = 104;
    private static final Integer TOUCH_CHANNEL = 105;
    public static final int FOOTSWITCH_2_PREV_MODE = 15;
    public static final int FOOTSWITCH_2_NEXT_MODE = 16;
    public static final int SHOW_MARKER_MODE = 17;
    private static final String DEVICE_SELECT = "<Select a profile>";
    private static final String DEVICE_ICON_QCON_PRO_X = "icon QConPro X";
    private static final String DEVICE_MACKIE_HUI = "Mackie HUI";
    private static final String DEVICE_NOVATION_SLMKIII = "Novation MkIII";
    private static final String DEVICE_YAMAHA_DM3 = "Yamaha DM3";
    private static final String[] DEVICE_OPTIONS = new String[]{"<Select a profile>", "icon QConPro X", "Mackie HUI", "Novation MkIII", "Yamaha DM3"};
    private static final String[] ASSIGNABLE_BUTTON_NAMES = new String[]{"Footswitch 1", "Footswitch 2", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8"};
    private IEnumSetting zoomStateSetting;
    private IEnumSetting hasDisplay1Setting;
    private IEnumSetting hasSegmentDisplaySetting;
    private IEnumSetting hasMotorFadersSetting;
    private boolean zoomState;
    private boolean hasDisplay1;
    private boolean hasSegmentDisplay;
    private boolean hasMotorFaders;
    private boolean touchChannel;
    private boolean sendPing;
    private final int[] assignableFunctions = new int[10];

    public HUIConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
        Arrays.fill(this.assignableFunctions, 0);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateHardwareSettings(globalSettings);
        this.activateEnableVUMetersSetting(globalSettings, "Hardware Setup");
        this.activateAssignableSettings(globalSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateZoomStateSetting(globalSettings);
        this.activateChannelTouchSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
    }

    private void activateHardwareSettings(ISettingsUI settingsUI) {
        IEnumSetting profileSetting = settingsUI.getEnumSetting("Profile", "Hardware Setup", DEVICE_OPTIONS, DEVICE_OPTIONS[0]);
        profileSetting.addValueObserver(value -> {
            switch (value) {
                case "Mackie HUI": 
                case "icon QConPro X": 
                case "Yamaha DM3": {
                    this.hasDisplay1Setting.set(ON_OFF_OPTIONS[1]);
                    this.hasSegmentDisplaySetting.set(ON_OFF_OPTIONS[1]);
                    this.hasMotorFadersSetting.set(ON_OFF_OPTIONS[1]);
                    this.setVUMetersEnabled(true);
                    break;
                }
                case "Novation MkIII": {
                    this.hasDisplay1Setting.set(ON_OFF_OPTIONS[1]);
                    this.hasSegmentDisplaySetting.set(ON_OFF_OPTIONS[0]);
                    this.hasMotorFadersSetting.set(ON_OFF_OPTIONS[0]);
                    this.setVUMetersEnabled(false);
                    break;
                }
                default: {
                    return;
                }
            }
            profileSetting.set(DEVICE_SELECT);
        });
        this.hasDisplay1Setting = settingsUI.getEnumSetting("Has a display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasDisplay1Setting.addValueObserver(value -> {
            this.hasDisplay1 = "On".equals(value);
            this.notifyObservers(HAS_DISPLAY1);
        });
        this.hasSegmentDisplaySetting = settingsUI.getEnumSetting("Has a position/tempo display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasSegmentDisplaySetting.addValueObserver(value -> {
            this.hasSegmentDisplay = "On".equals(value);
            this.notifyObservers(HAS_SEGMENT_DISPLAY);
        });
        this.hasMotorFadersSetting = settingsUI.getEnumSetting("Has motor faders", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasMotorFadersSetting.addValueObserver(value -> {
            this.hasMotorFaders = "On".equals(value);
            this.notifyObservers(HAS_MOTOR_FADERS);
        });
        IEnumSetting sendPingSetting = settingsUI.getEnumSetting("Send ping", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        sendPingSetting.addValueObserver(value -> {
            this.sendPing = "On".equals(value);
            this.notifyObservers(HAS_MOTOR_FADERS);
        });
        this.isSettingActive.add(HAS_DISPLAY1);
        this.isSettingActive.add(HAS_SEGMENT_DISPLAY);
        this.isSettingActive.add(HAS_MOTOR_FADERS);
        this.isSettingActive.add(SEND_PING);
    }

    private void activateAssignableSettings(ISettingsUI settingsUI) {
        for (int i = 0; i < this.assignableFunctions.length; ++i) {
            int pos = i;
            IEnumSetting setting = settingsUI.getEnumSetting(ASSIGNABLE_BUTTON_NAMES[i], "Assignable buttons", FOOTSWITCH_VALUES, FOOTSWITCH_VALUES[6]);
            setting.addValueObserver(value -> {
                this.assignableFunctions[pos] = HUIConfiguration.lookupIndex(FOOTSWITCH_VALUES, value);
            });
        }
    }

    protected void activateZoomStateSetting(ISettingsUI settingsUI) {
        this.zoomStateSetting = settingsUI.getEnumSetting("Zoom", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.zoomStateSetting.addValueObserver(value -> {
            this.zoomState = "On".equals(value);
            this.notifyObservers(ZOOM_STATE);
        });
        this.isSettingActive.add(ZOOM_STATE);
    }

    protected void activateChannelTouchSetting(ISettingsUI settingsUI) {
        IEnumSetting touchChannelSetting = settingsUI.getEnumSetting("Select Channel on Fader Touch", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        touchChannelSetting.addValueObserver(value -> {
            this.touchChannel = "On".equals(value);
            this.notifyObservers(TOUCH_CHANNEL);
        });
        this.isSettingActive.add(TOUCH_CHANNEL);
    }

    public boolean isZoomState() {
        return this.zoomState;
    }

    public void toggleZoomState() {
        this.zoomStateSetting.set(this.zoomState ? ON_OFF_OPTIONS[0] : ON_OFF_OPTIONS[1]);
    }

    public boolean hasDisplay1() {
        return this.hasDisplay1;
    }

    public boolean hasSegmentDisplay() {
        return this.hasSegmentDisplay;
    }

    public boolean hasMotorFaders() {
        return this.hasMotorFaders;
    }

    public boolean shouldSendPing() {
        return this.sendPing;
    }

    public int getAssignable(int index) {
        return this.assignableFunctions[index];
    }

    public boolean isTouchChannel() {
        return this.touchChannel;
    }
}

