/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.Optional;

public class FxTrackHandler
extends AbstractHandler {
    public FxTrackHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.FX_TRACK_SELECT_PREVIOUS_BANK_PAGE, FlexiCommand.FX_TRACK_SELECT_NEXT_BANK_PAGE, FlexiCommand.FX_TRACK_SELECT_PREVIOUS_TRACK, FlexiCommand.FX_TRACK_SELECT_NEXT_TRACK, FlexiCommand.FX_TRACK_SCROLL_BANK_PAGE_BY_1_LEFT, FlexiCommand.FX_TRACK_SCROLL_BANK_PAGE_BY_1_RIGHT, FlexiCommand.FX_TRACK_SCROLL_TRACKS, FlexiCommand.FX_TRACK_1_SELECT, FlexiCommand.FX_TRACK_2_SELECT, FlexiCommand.FX_TRACK_3_SELECT, FlexiCommand.FX_TRACK_4_SELECT, FlexiCommand.FX_TRACK_5_SELECT, FlexiCommand.FX_TRACK_6_SELECT, FlexiCommand.FX_TRACK_7_SELECT, FlexiCommand.FX_TRACK_8_SELECT, FlexiCommand.FX_TRACK_1_TOGGLE_ACTIVE, FlexiCommand.FX_TRACK_2_TOGGLE_ACTIVE, FlexiCommand.FX_TRACK_3_TOGGLE_ACTIVE, FlexiCommand.FX_TRACK_4_TOGGLE_ACTIVE, FlexiCommand.FX_TRACK_5_TOGGLE_ACTIVE, FlexiCommand.FX_TRACK_6_TOGGLE_ACTIVE, FlexiCommand.FX_TRACK_7_TOGGLE_ACTIVE, FlexiCommand.FX_TRACK_8_TOGGLE_ACTIVE, FlexiCommand.FX_TRACK_1_SET_ACTIVE, FlexiCommand.FX_TRACK_2_SET_ACTIVE, FlexiCommand.FX_TRACK_3_SET_ACTIVE, FlexiCommand.FX_TRACK_4_SET_ACTIVE, FlexiCommand.FX_TRACK_5_SET_ACTIVE, FlexiCommand.FX_TRACK_6_SET_ACTIVE, FlexiCommand.FX_TRACK_7_SET_ACTIVE, FlexiCommand.FX_TRACK_8_SET_ACTIVE, FlexiCommand.FX_TRACK_1_SET_VOLUME, FlexiCommand.FX_TRACK_2_SET_VOLUME, FlexiCommand.FX_TRACK_3_SET_VOLUME, FlexiCommand.FX_TRACK_4_SET_VOLUME, FlexiCommand.FX_TRACK_5_SET_VOLUME, FlexiCommand.FX_TRACK_6_SET_VOLUME, FlexiCommand.FX_TRACK_7_SET_VOLUME, FlexiCommand.FX_TRACK_8_SET_VOLUME, FlexiCommand.FX_TRACK_1_SET_PANNING, FlexiCommand.FX_TRACK_2_SET_PANNING, FlexiCommand.FX_TRACK_3_SET_PANNING, FlexiCommand.FX_TRACK_4_SET_PANNING, FlexiCommand.FX_TRACK_5_SET_PANNING, FlexiCommand.FX_TRACK_6_SET_PANNING, FlexiCommand.FX_TRACK_7_SET_PANNING, FlexiCommand.FX_TRACK_8_SET_PANNING, FlexiCommand.FX_TRACK_1_TOGGLE_MUTE, FlexiCommand.FX_TRACK_2_TOGGLE_MUTE, FlexiCommand.FX_TRACK_3_TOGGLE_MUTE, FlexiCommand.FX_TRACK_4_TOGGLE_MUTE, FlexiCommand.FX_TRACK_5_TOGGLE_MUTE, FlexiCommand.FX_TRACK_6_TOGGLE_MUTE, FlexiCommand.FX_TRACK_7_TOGGLE_MUTE, FlexiCommand.FX_TRACK_8_TOGGLE_MUTE, FlexiCommand.FX_TRACK_1_SET_MUTE, FlexiCommand.FX_TRACK_2_SET_MUTE, FlexiCommand.FX_TRACK_3_SET_MUTE, FlexiCommand.FX_TRACK_4_SET_MUTE, FlexiCommand.FX_TRACK_5_SET_MUTE, FlexiCommand.FX_TRACK_6_SET_MUTE, FlexiCommand.FX_TRACK_7_SET_MUTE, FlexiCommand.FX_TRACK_8_SET_MUTE, FlexiCommand.FX_TRACK_1_TOGGLE_SOLO, FlexiCommand.FX_TRACK_2_TOGGLE_SOLO, FlexiCommand.FX_TRACK_3_TOGGLE_SOLO, FlexiCommand.FX_TRACK_4_TOGGLE_SOLO, FlexiCommand.FX_TRACK_5_TOGGLE_SOLO, FlexiCommand.FX_TRACK_6_TOGGLE_SOLO, FlexiCommand.FX_TRACK_7_TOGGLE_SOLO, FlexiCommand.FX_TRACK_8_TOGGLE_SOLO, FlexiCommand.FX_TRACK_1_SET_SOLO, FlexiCommand.FX_TRACK_2_SET_SOLO, FlexiCommand.FX_TRACK_3_SET_SOLO, FlexiCommand.FX_TRACK_4_SET_SOLO, FlexiCommand.FX_TRACK_5_SET_SOLO, FlexiCommand.FX_TRACK_6_SET_SOLO, FlexiCommand.FX_TRACK_7_SET_SOLO, FlexiCommand.FX_TRACK_8_SET_SOLO, FlexiCommand.FX_TRACK_1_TOGGLE_ARM, FlexiCommand.FX_TRACK_2_TOGGLE_ARM, FlexiCommand.FX_TRACK_3_TOGGLE_ARM, FlexiCommand.FX_TRACK_4_TOGGLE_ARM, FlexiCommand.FX_TRACK_5_TOGGLE_ARM, FlexiCommand.FX_TRACK_6_TOGGLE_ARM, FlexiCommand.FX_TRACK_7_TOGGLE_ARM, FlexiCommand.FX_TRACK_8_TOGGLE_ARM, FlexiCommand.FX_TRACK_1_SET_ARM, FlexiCommand.FX_TRACK_2_SET_ARM, FlexiCommand.FX_TRACK_3_SET_ARM, FlexiCommand.FX_TRACK_4_SET_ARM, FlexiCommand.FX_TRACK_5_SET_ARM, FlexiCommand.FX_TRACK_6_SET_ARM, FlexiCommand.FX_TRACK_7_SET_ARM, FlexiCommand.FX_TRACK_8_SET_ARM, FlexiCommand.FX_TRACK_1_TOGGLE_MONITOR, FlexiCommand.FX_TRACK_2_TOGGLE_MONITOR, FlexiCommand.FX_TRACK_3_TOGGLE_MONITOR, FlexiCommand.FX_TRACK_4_TOGGLE_MONITOR, FlexiCommand.FX_TRACK_5_TOGGLE_MONITOR, FlexiCommand.FX_TRACK_6_TOGGLE_MONITOR, FlexiCommand.FX_TRACK_7_TOGGLE_MONITOR, FlexiCommand.FX_TRACK_8_TOGGLE_MONITOR, FlexiCommand.FX_TRACK_1_SET_MONITOR, FlexiCommand.FX_TRACK_2_SET_MONITOR, FlexiCommand.FX_TRACK_3_SET_MONITOR, FlexiCommand.FX_TRACK_4_SET_MONITOR, FlexiCommand.FX_TRACK_5_SET_MONITOR, FlexiCommand.FX_TRACK_6_SET_MONITOR, FlexiCommand.FX_TRACK_7_SET_MONITOR, FlexiCommand.FX_TRACK_8_SET_MONITOR, FlexiCommand.FX_TRACK_1_TOGGLE_AUTO_MONITOR, FlexiCommand.FX_TRACK_2_TOGGLE_AUTO_MONITOR, FlexiCommand.FX_TRACK_3_TOGGLE_AUTO_MONITOR, FlexiCommand.FX_TRACK_4_TOGGLE_AUTO_MONITOR, FlexiCommand.FX_TRACK_5_TOGGLE_AUTO_MONITOR, FlexiCommand.FX_TRACK_6_TOGGLE_AUTO_MONITOR, FlexiCommand.FX_TRACK_7_TOGGLE_AUTO_MONITOR, FlexiCommand.FX_TRACK_8_TOGGLE_AUTO_MONITOR, FlexiCommand.FX_TRACK_1_SET_AUTO_MONITOR, FlexiCommand.FX_TRACK_2_SET_AUTO_MONITOR, FlexiCommand.FX_TRACK_3_SET_AUTO_MONITOR, FlexiCommand.FX_TRACK_4_SET_AUTO_MONITOR, FlexiCommand.FX_TRACK_5_SET_AUTO_MONITOR, FlexiCommand.FX_TRACK_6_SET_AUTO_MONITOR, FlexiCommand.FX_TRACK_7_SET_AUTO_MONITOR, FlexiCommand.FX_TRACK_8_SET_AUTO_MONITOR, FlexiCommand.FX_TRACK_1_SET_SEND_1, FlexiCommand.FX_TRACK_2_SET_SEND_1, FlexiCommand.FX_TRACK_3_SET_SEND_1, FlexiCommand.FX_TRACK_4_SET_SEND_1, FlexiCommand.FX_TRACK_5_SET_SEND_1, FlexiCommand.FX_TRACK_6_SET_SEND_1, FlexiCommand.FX_TRACK_7_SET_SEND_1, FlexiCommand.FX_TRACK_8_SET_SEND_1, FlexiCommand.FX_TRACK_1_SET_SEND_2, FlexiCommand.FX_TRACK_2_SET_SEND_2, FlexiCommand.FX_TRACK_3_SET_SEND_2, FlexiCommand.FX_TRACK_4_SET_SEND_2, FlexiCommand.FX_TRACK_5_SET_SEND_2, FlexiCommand.FX_TRACK_6_SET_SEND_2, FlexiCommand.FX_TRACK_7_SET_SEND_2, FlexiCommand.FX_TRACK_8_SET_SEND_2, FlexiCommand.FX_TRACK_1_SET_SEND_3, FlexiCommand.FX_TRACK_2_SET_SEND_3, FlexiCommand.FX_TRACK_3_SET_SEND_3, FlexiCommand.FX_TRACK_4_SET_SEND_3, FlexiCommand.FX_TRACK_5_SET_SEND_3, FlexiCommand.FX_TRACK_6_SET_SEND_3, FlexiCommand.FX_TRACK_7_SET_SEND_3, FlexiCommand.FX_TRACK_8_SET_SEND_3, FlexiCommand.FX_TRACK_1_SET_SEND_4, FlexiCommand.FX_TRACK_2_SET_SEND_4, FlexiCommand.FX_TRACK_3_SET_SEND_4, FlexiCommand.FX_TRACK_4_SET_SEND_4, FlexiCommand.FX_TRACK_5_SET_SEND_4, FlexiCommand.FX_TRACK_6_SET_SEND_4, FlexiCommand.FX_TRACK_7_SET_SEND_4, FlexiCommand.FX_TRACK_8_SET_SEND_4, FlexiCommand.FX_TRACK_1_SET_SEND_5, FlexiCommand.FX_TRACK_2_SET_SEND_5, FlexiCommand.FX_TRACK_3_SET_SEND_5, FlexiCommand.FX_TRACK_4_SET_SEND_5, FlexiCommand.FX_TRACK_5_SET_SEND_5, FlexiCommand.FX_TRACK_6_SET_SEND_5, FlexiCommand.FX_TRACK_7_SET_SEND_5, FlexiCommand.FX_TRACK_8_SET_SEND_5, FlexiCommand.FX_TRACK_1_SET_SEND_6, FlexiCommand.FX_TRACK_2_SET_SEND_6, FlexiCommand.FX_TRACK_3_SET_SEND_6, FlexiCommand.FX_TRACK_4_SET_SEND_6, FlexiCommand.FX_TRACK_5_SET_SEND_6, FlexiCommand.FX_TRACK_6_SET_SEND_6, FlexiCommand.FX_TRACK_7_SET_SEND_6, FlexiCommand.FX_TRACK_8_SET_SEND_6, FlexiCommand.FX_TRACK_1_SET_SEND_7, FlexiCommand.FX_TRACK_2_SET_SEND_7, FlexiCommand.FX_TRACK_3_SET_SEND_7, FlexiCommand.FX_TRACK_4_SET_SEND_7, FlexiCommand.FX_TRACK_5_SET_SEND_7, FlexiCommand.FX_TRACK_6_SET_SEND_7, FlexiCommand.FX_TRACK_7_SET_SEND_7, FlexiCommand.FX_TRACK_8_SET_SEND_7, FlexiCommand.FX_TRACK_1_SET_SEND_8, FlexiCommand.FX_TRACK_2_SET_SEND_8, FlexiCommand.FX_TRACK_3_SET_SEND_8, FlexiCommand.FX_TRACK_4_SET_SEND_8, FlexiCommand.FX_TRACK_5_SET_SEND_8, FlexiCommand.FX_TRACK_6_SET_SEND_8, FlexiCommand.FX_TRACK_7_SET_SEND_8, FlexiCommand.FX_TRACK_8_SET_SEND_8, FlexiCommand.FX_TRACK_SELECTED_SET_SEND_1, FlexiCommand.FX_TRACK_SELECTED_SET_SEND_2, FlexiCommand.FX_TRACK_SELECTED_SET_SEND_3, FlexiCommand.FX_TRACK_SELECTED_SET_SEND_4, FlexiCommand.FX_TRACK_SELECTED_SET_SEND_5, FlexiCommand.FX_TRACK_SELECTED_SET_SEND_6, FlexiCommand.FX_TRACK_SELECTED_SET_SEND_7, FlexiCommand.FX_TRACK_SELECTED_SET_SEND_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank == null) {
            return -1;
        }
        switch (command) {
            case TRACK_SELECT_PREVIOUS_BANK_PAGE: {
                return FxTrackHandler.toMidiValue(effectTrackBank.canScrollPageBackwards());
            }
            case TRACK_SELECT_NEXT_BANK_PAGE: {
                return FxTrackHandler.toMidiValue(effectTrackBank.canScrollPageForwards());
            }
            case TRACK_SELECT_PREVIOUS_TRACK: 
            case TRACK_SCROLL_BANK_PAGE_BY_1_LEFT: {
                return FxTrackHandler.toMidiValue(effectTrackBank.canScrollBackwards());
            }
            case TRACK_SELECT_NEXT_TRACK: 
            case TRACK_SCROLL_BANK_PAGE_BY_1_RIGHT: {
                return FxTrackHandler.toMidiValue(effectTrackBank.canScrollForwards());
            }
            case FX_TRACK_1_SELECT: 
            case FX_TRACK_2_SELECT: 
            case FX_TRACK_3_SELECT: 
            case FX_TRACK_4_SELECT: 
            case FX_TRACK_5_SELECT: 
            case FX_TRACK_6_SELECT: 
            case FX_TRACK_7_SELECT: 
            case FX_TRACK_8_SELECT: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SELECT.ordinal())).isSelected());
            }
            case FX_TRACK_1_TOGGLE_ACTIVE: 
            case FX_TRACK_2_TOGGLE_ACTIVE: 
            case FX_TRACK_3_TOGGLE_ACTIVE: 
            case FX_TRACK_4_TOGGLE_ACTIVE: 
            case FX_TRACK_5_TOGGLE_ACTIVE: 
            case FX_TRACK_6_TOGGLE_ACTIVE: 
            case FX_TRACK_7_TOGGLE_ACTIVE: 
            case FX_TRACK_8_TOGGLE_ACTIVE: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_ACTIVE.ordinal())).isActivated());
            }
            case FX_TRACK_1_SET_ACTIVE: 
            case FX_TRACK_2_SET_ACTIVE: 
            case FX_TRACK_3_SET_ACTIVE: 
            case FX_TRACK_4_SET_ACTIVE: 
            case FX_TRACK_5_SET_ACTIVE: 
            case FX_TRACK_6_SET_ACTIVE: 
            case FX_TRACK_7_SET_ACTIVE: 
            case FX_TRACK_8_SET_ACTIVE: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_ACTIVE.ordinal())).isActivated());
            }
            case FX_TRACK_1_SET_VOLUME: 
            case FX_TRACK_2_SET_VOLUME: 
            case FX_TRACK_3_SET_VOLUME: 
            case FX_TRACK_4_SET_VOLUME: 
            case FX_TRACK_5_SET_VOLUME: 
            case FX_TRACK_6_SET_VOLUME: 
            case FX_TRACK_7_SET_VOLUME: 
            case FX_TRACK_8_SET_VOLUME: {
                return ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_VOLUME.ordinal())).getVolume();
            }
            case FX_TRACK_1_SET_PANNING: 
            case FX_TRACK_2_SET_PANNING: 
            case FX_TRACK_3_SET_PANNING: 
            case FX_TRACK_4_SET_PANNING: 
            case FX_TRACK_5_SET_PANNING: 
            case FX_TRACK_6_SET_PANNING: 
            case FX_TRACK_7_SET_PANNING: 
            case FX_TRACK_8_SET_PANNING: {
                return ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_PANNING.ordinal())).getPan();
            }
            case FX_TRACK_1_TOGGLE_MUTE: 
            case FX_TRACK_2_TOGGLE_MUTE: 
            case FX_TRACK_3_TOGGLE_MUTE: 
            case FX_TRACK_4_TOGGLE_MUTE: 
            case FX_TRACK_5_TOGGLE_MUTE: 
            case FX_TRACK_6_TOGGLE_MUTE: 
            case FX_TRACK_7_TOGGLE_MUTE: 
            case FX_TRACK_8_TOGGLE_MUTE: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_MUTE.ordinal())).isMute());
            }
            case FX_TRACK_1_SET_MUTE: 
            case FX_TRACK_2_SET_MUTE: 
            case FX_TRACK_3_SET_MUTE: 
            case FX_TRACK_4_SET_MUTE: 
            case FX_TRACK_5_SET_MUTE: 
            case FX_TRACK_6_SET_MUTE: 
            case FX_TRACK_7_SET_MUTE: 
            case FX_TRACK_8_SET_MUTE: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_MUTE.ordinal())).isMute());
            }
            case FX_TRACK_1_TOGGLE_SOLO: 
            case FX_TRACK_2_TOGGLE_SOLO: 
            case FX_TRACK_3_TOGGLE_SOLO: 
            case FX_TRACK_4_TOGGLE_SOLO: 
            case FX_TRACK_5_TOGGLE_SOLO: 
            case FX_TRACK_6_TOGGLE_SOLO: 
            case FX_TRACK_7_TOGGLE_SOLO: 
            case FX_TRACK_8_TOGGLE_SOLO: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_SOLO.ordinal())).isSolo());
            }
            case FX_TRACK_1_SET_SOLO: 
            case FX_TRACK_2_SET_SOLO: 
            case FX_TRACK_3_SET_SOLO: 
            case FX_TRACK_4_SET_SOLO: 
            case FX_TRACK_5_SET_SOLO: 
            case FX_TRACK_6_SET_SOLO: 
            case FX_TRACK_7_SET_SOLO: 
            case FX_TRACK_8_SET_SOLO: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SOLO.ordinal())).isSolo());
            }
            case FX_TRACK_1_TOGGLE_ARM: 
            case FX_TRACK_2_TOGGLE_ARM: 
            case FX_TRACK_3_TOGGLE_ARM: 
            case FX_TRACK_4_TOGGLE_ARM: 
            case FX_TRACK_5_TOGGLE_ARM: 
            case FX_TRACK_6_TOGGLE_ARM: 
            case FX_TRACK_7_TOGGLE_ARM: 
            case FX_TRACK_8_TOGGLE_ARM: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_ARM.ordinal())).isRecArm());
            }
            case FX_TRACK_1_SET_ARM: 
            case FX_TRACK_2_SET_ARM: 
            case FX_TRACK_3_SET_ARM: 
            case FX_TRACK_4_SET_ARM: 
            case FX_TRACK_5_SET_ARM: 
            case FX_TRACK_6_SET_ARM: 
            case FX_TRACK_7_SET_ARM: 
            case FX_TRACK_8_SET_ARM: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_ARM.ordinal())).isRecArm());
            }
            case FX_TRACK_1_TOGGLE_MONITOR: 
            case FX_TRACK_2_TOGGLE_MONITOR: 
            case FX_TRACK_3_TOGGLE_MONITOR: 
            case FX_TRACK_4_TOGGLE_MONITOR: 
            case FX_TRACK_5_TOGGLE_MONITOR: 
            case FX_TRACK_6_TOGGLE_MONITOR: 
            case FX_TRACK_7_TOGGLE_MONITOR: 
            case FX_TRACK_8_TOGGLE_MONITOR: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_MONITOR.ordinal())).isMonitor());
            }
            case FX_TRACK_1_SET_MONITOR: 
            case FX_TRACK_2_SET_MONITOR: 
            case FX_TRACK_3_SET_MONITOR: 
            case FX_TRACK_4_SET_MONITOR: 
            case FX_TRACK_5_SET_MONITOR: 
            case FX_TRACK_6_SET_MONITOR: 
            case FX_TRACK_7_SET_MONITOR: 
            case FX_TRACK_8_SET_MONITOR: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_MONITOR.ordinal())).isMonitor());
            }
            case FX_TRACK_1_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_2_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_3_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_4_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_5_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_6_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_7_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_8_TOGGLE_AUTO_MONITOR: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_AUTO_MONITOR.ordinal())).isAutoMonitor());
            }
            case FX_TRACK_1_SET_AUTO_MONITOR: 
            case FX_TRACK_2_SET_AUTO_MONITOR: 
            case FX_TRACK_3_SET_AUTO_MONITOR: 
            case FX_TRACK_4_SET_AUTO_MONITOR: 
            case FX_TRACK_5_SET_AUTO_MONITOR: 
            case FX_TRACK_6_SET_AUTO_MONITOR: 
            case FX_TRACK_7_SET_AUTO_MONITOR: 
            case FX_TRACK_8_SET_AUTO_MONITOR: {
                return FxTrackHandler.toMidiValue(((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_AUTO_MONITOR.ordinal())).isAutoMonitor());
            }
            case FX_TRACK_1_SET_SEND_1: 
            case FX_TRACK_2_SET_SEND_1: 
            case FX_TRACK_3_SET_SEND_1: 
            case FX_TRACK_4_SET_SEND_1: 
            case FX_TRACK_5_SET_SEND_1: 
            case FX_TRACK_6_SET_SEND_1: 
            case FX_TRACK_7_SET_SEND_1: 
            case FX_TRACK_8_SET_SEND_1: {
                return this.getSendValue(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_1.ordinal(), 0);
            }
            case FX_TRACK_1_SET_SEND_2: 
            case FX_TRACK_2_SET_SEND_2: 
            case FX_TRACK_3_SET_SEND_2: 
            case FX_TRACK_4_SET_SEND_2: 
            case FX_TRACK_5_SET_SEND_2: 
            case FX_TRACK_6_SET_SEND_2: 
            case FX_TRACK_7_SET_SEND_2: 
            case FX_TRACK_8_SET_SEND_2: {
                return this.getSendValue(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_2.ordinal(), 1);
            }
            case FX_TRACK_1_SET_SEND_3: 
            case FX_TRACK_2_SET_SEND_3: 
            case FX_TRACK_3_SET_SEND_3: 
            case FX_TRACK_4_SET_SEND_3: 
            case FX_TRACK_5_SET_SEND_3: 
            case FX_TRACK_6_SET_SEND_3: 
            case FX_TRACK_7_SET_SEND_3: 
            case FX_TRACK_8_SET_SEND_3: {
                return this.getSendValue(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_3.ordinal(), 2);
            }
            case FX_TRACK_1_SET_SEND_4: 
            case FX_TRACK_2_SET_SEND_4: 
            case FX_TRACK_3_SET_SEND_4: 
            case FX_TRACK_4_SET_SEND_4: 
            case FX_TRACK_5_SET_SEND_4: 
            case FX_TRACK_6_SET_SEND_4: 
            case FX_TRACK_7_SET_SEND_4: 
            case FX_TRACK_8_SET_SEND_4: {
                return this.getSendValue(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_4.ordinal(), 3);
            }
            case FX_TRACK_1_SET_SEND_5: 
            case FX_TRACK_2_SET_SEND_5: 
            case FX_TRACK_3_SET_SEND_5: 
            case FX_TRACK_4_SET_SEND_5: 
            case FX_TRACK_5_SET_SEND_5: 
            case FX_TRACK_6_SET_SEND_5: 
            case FX_TRACK_7_SET_SEND_5: 
            case FX_TRACK_8_SET_SEND_5: {
                return this.getSendValue(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_5.ordinal(), 4);
            }
            case FX_TRACK_1_SET_SEND_6: 
            case FX_TRACK_2_SET_SEND_6: 
            case FX_TRACK_3_SET_SEND_6: 
            case FX_TRACK_4_SET_SEND_6: 
            case FX_TRACK_5_SET_SEND_6: 
            case FX_TRACK_6_SET_SEND_6: 
            case FX_TRACK_7_SET_SEND_6: 
            case FX_TRACK_8_SET_SEND_6: {
                return this.getSendValue(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_6.ordinal(), 5);
            }
            case FX_TRACK_1_SET_SEND_7: 
            case FX_TRACK_2_SET_SEND_7: 
            case FX_TRACK_3_SET_SEND_7: 
            case FX_TRACK_4_SET_SEND_7: 
            case FX_TRACK_5_SET_SEND_7: 
            case FX_TRACK_6_SET_SEND_7: 
            case FX_TRACK_7_SET_SEND_7: 
            case FX_TRACK_8_SET_SEND_7: {
                return this.getSendValue(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_7.ordinal(), 6);
            }
            case FX_TRACK_1_SET_SEND_8: 
            case FX_TRACK_2_SET_SEND_8: 
            case FX_TRACK_3_SET_SEND_8: 
            case FX_TRACK_4_SET_SEND_8: 
            case FX_TRACK_5_SET_SEND_8: 
            case FX_TRACK_6_SET_SEND_8: 
            case FX_TRACK_7_SET_SEND_8: 
            case FX_TRACK_8_SET_SEND_8: {
                return this.getSendValue(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_8.ordinal(), 7);
            }
            case FX_TRACK_SELECTED_SET_SEND_1: 
            case FX_TRACK_SELECTED_SET_SEND_2: 
            case FX_TRACK_SELECTED_SET_SEND_3: 
            case FX_TRACK_SELECTED_SET_SEND_4: 
            case FX_TRACK_SELECTED_SET_SEND_5: 
            case FX_TRACK_SELECTED_SET_SEND_6: 
            case FX_TRACK_SELECTED_SET_SEND_7: 
            case FX_TRACK_SELECTED_SET_SEND_8: {
                return this.getSendValue(-1, command.ordinal() - FlexiCommand.FX_TRACK_SELECTED_SET_SEND_1.ordinal());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank == null) {
            return;
        }
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case FX_TRACK_SELECT_PREVIOUS_BANK_PAGE: {
                if (!isButtonPressed) break;
                this.scrollTrackLeft(true);
                break;
            }
            case FX_TRACK_SELECT_NEXT_BANK_PAGE: {
                if (!isButtonPressed) break;
                this.scrollTrackRight(true);
                break;
            }
            case FX_TRACK_SELECT_PREVIOUS_TRACK: {
                if (!isButtonPressed) break;
                this.scrollTrackLeft(false);
                break;
            }
            case FX_TRACK_SELECT_NEXT_TRACK: {
                if (!isButtonPressed) break;
                this.scrollTrackRight(false);
                break;
            }
            case TRACK_SCROLL_BANK_PAGE_BY_1_LEFT: {
                if (!isButtonPressed) break;
                effectTrackBank.scrollBackwards();
                break;
            }
            case TRACK_SCROLL_BANK_PAGE_BY_1_RIGHT: {
                if (!isButtonPressed) break;
                effectTrackBank.scrollForwards();
                break;
            }
            case FX_TRACK_SCROLL_TRACKS: {
                this.scrollTrack(knobMode, value);
                break;
            }
            case FX_TRACK_1_SELECT: 
            case FX_TRACK_2_SELECT: 
            case FX_TRACK_3_SELECT: 
            case FX_TRACK_4_SELECT: 
            case FX_TRACK_5_SELECT: 
            case FX_TRACK_6_SELECT: 
            case FX_TRACK_7_SELECT: 
            case FX_TRACK_8_SELECT: {
                if (!isButtonPressed) break;
                ITrack track = (ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SELECT.ordinal());
                track.select();
                this.mvHelper.notifySelectedTrack();
                break;
            }
            case FX_TRACK_1_TOGGLE_ACTIVE: 
            case FX_TRACK_2_TOGGLE_ACTIVE: 
            case FX_TRACK_3_TOGGLE_ACTIVE: 
            case FX_TRACK_4_TOGGLE_ACTIVE: 
            case FX_TRACK_5_TOGGLE_ACTIVE: 
            case FX_TRACK_6_TOGGLE_ACTIVE: 
            case FX_TRACK_7_TOGGLE_ACTIVE: 
            case FX_TRACK_8_TOGGLE_ACTIVE: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_ACTIVE.ordinal())).toggleIsActivated();
                break;
            }
            case FX_TRACK_1_SET_ACTIVE: 
            case FX_TRACK_2_SET_ACTIVE: 
            case FX_TRACK_3_SET_ACTIVE: 
            case FX_TRACK_4_SET_ACTIVE: 
            case FX_TRACK_5_SET_ACTIVE: 
            case FX_TRACK_6_SET_ACTIVE: 
            case FX_TRACK_7_SET_ACTIVE: 
            case FX_TRACK_8_SET_ACTIVE: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_ACTIVE.ordinal())).setIsActivated(value.isPositive());
                break;
            }
            case FX_TRACK_1_SET_VOLUME: 
            case FX_TRACK_2_SET_VOLUME: 
            case FX_TRACK_3_SET_VOLUME: 
            case FX_TRACK_4_SET_VOLUME: 
            case FX_TRACK_5_SET_VOLUME: 
            case FX_TRACK_6_SET_VOLUME: 
            case FX_TRACK_7_SET_VOLUME: 
            case FX_TRACK_8_SET_VOLUME: {
                this.changeTrackVolume(knobMode, command.ordinal() - FlexiCommand.FX_TRACK_1_SET_VOLUME.ordinal(), value);
                break;
            }
            case FX_TRACK_1_SET_PANNING: 
            case FX_TRACK_2_SET_PANNING: 
            case FX_TRACK_3_SET_PANNING: 
            case FX_TRACK_4_SET_PANNING: 
            case FX_TRACK_5_SET_PANNING: 
            case FX_TRACK_6_SET_PANNING: 
            case FX_TRACK_7_SET_PANNING: 
            case FX_TRACK_8_SET_PANNING: {
                this.changeTrackPanning(knobMode, command.ordinal() - FlexiCommand.FX_TRACK_1_SET_PANNING.ordinal(), value);
                break;
            }
            case FX_TRACK_1_TOGGLE_MUTE: 
            case FX_TRACK_2_TOGGLE_MUTE: 
            case FX_TRACK_3_TOGGLE_MUTE: 
            case FX_TRACK_4_TOGGLE_MUTE: 
            case FX_TRACK_5_TOGGLE_MUTE: 
            case FX_TRACK_6_TOGGLE_MUTE: 
            case FX_TRACK_7_TOGGLE_MUTE: 
            case FX_TRACK_8_TOGGLE_MUTE: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_MUTE.ordinal())).toggleMute();
                break;
            }
            case FX_TRACK_1_SET_MUTE: 
            case FX_TRACK_2_SET_MUTE: 
            case FX_TRACK_3_SET_MUTE: 
            case FX_TRACK_4_SET_MUTE: 
            case FX_TRACK_5_SET_MUTE: 
            case FX_TRACK_6_SET_MUTE: 
            case FX_TRACK_7_SET_MUTE: 
            case FX_TRACK_8_SET_MUTE: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_MUTE.ordinal())).setMute(value.isPositive());
                break;
            }
            case FX_TRACK_1_TOGGLE_SOLO: 
            case FX_TRACK_2_TOGGLE_SOLO: 
            case FX_TRACK_3_TOGGLE_SOLO: 
            case FX_TRACK_4_TOGGLE_SOLO: 
            case FX_TRACK_5_TOGGLE_SOLO: 
            case FX_TRACK_6_TOGGLE_SOLO: 
            case FX_TRACK_7_TOGGLE_SOLO: 
            case FX_TRACK_8_TOGGLE_SOLO: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_SOLO.ordinal())).toggleSolo();
                break;
            }
            case FX_TRACK_1_SET_SOLO: 
            case FX_TRACK_2_SET_SOLO: 
            case FX_TRACK_3_SET_SOLO: 
            case FX_TRACK_4_SET_SOLO: 
            case FX_TRACK_5_SET_SOLO: 
            case FX_TRACK_6_SET_SOLO: 
            case FX_TRACK_7_SET_SOLO: 
            case FX_TRACK_8_SET_SOLO: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SOLO.ordinal())).setSolo(value.isPositive());
                break;
            }
            case FX_TRACK_1_TOGGLE_ARM: 
            case FX_TRACK_2_TOGGLE_ARM: 
            case FX_TRACK_3_TOGGLE_ARM: 
            case FX_TRACK_4_TOGGLE_ARM: 
            case FX_TRACK_5_TOGGLE_ARM: 
            case FX_TRACK_6_TOGGLE_ARM: 
            case FX_TRACK_7_TOGGLE_ARM: 
            case FX_TRACK_8_TOGGLE_ARM: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_ARM.ordinal())).toggleRecArm();
                break;
            }
            case FX_TRACK_1_SET_ARM: 
            case FX_TRACK_2_SET_ARM: 
            case FX_TRACK_3_SET_ARM: 
            case FX_TRACK_4_SET_ARM: 
            case FX_TRACK_5_SET_ARM: 
            case FX_TRACK_6_SET_ARM: 
            case FX_TRACK_7_SET_ARM: 
            case FX_TRACK_8_SET_ARM: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_ARM.ordinal())).setRecArm(value.isPositive());
                break;
            }
            case FX_TRACK_1_TOGGLE_MONITOR: 
            case FX_TRACK_2_TOGGLE_MONITOR: 
            case FX_TRACK_3_TOGGLE_MONITOR: 
            case FX_TRACK_4_TOGGLE_MONITOR: 
            case FX_TRACK_5_TOGGLE_MONITOR: 
            case FX_TRACK_6_TOGGLE_MONITOR: 
            case FX_TRACK_7_TOGGLE_MONITOR: 
            case FX_TRACK_8_TOGGLE_MONITOR: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_MONITOR.ordinal())).toggleMonitor();
                break;
            }
            case FX_TRACK_1_SET_MONITOR: 
            case FX_TRACK_2_SET_MONITOR: 
            case FX_TRACK_3_SET_MONITOR: 
            case FX_TRACK_4_SET_MONITOR: 
            case FX_TRACK_5_SET_MONITOR: 
            case FX_TRACK_6_SET_MONITOR: 
            case FX_TRACK_7_SET_MONITOR: 
            case FX_TRACK_8_SET_MONITOR: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_MONITOR.ordinal())).setMonitor(value.isPositive());
                break;
            }
            case FX_TRACK_1_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_2_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_3_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_4_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_5_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_6_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_7_TOGGLE_AUTO_MONITOR: 
            case FX_TRACK_8_TOGGLE_AUTO_MONITOR: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_TOGGLE_AUTO_MONITOR.ordinal())).toggleAutoMonitor();
                break;
            }
            case FX_TRACK_1_SET_AUTO_MONITOR: 
            case FX_TRACK_2_SET_AUTO_MONITOR: 
            case FX_TRACK_3_SET_AUTO_MONITOR: 
            case FX_TRACK_4_SET_AUTO_MONITOR: 
            case FX_TRACK_5_SET_AUTO_MONITOR: 
            case FX_TRACK_6_SET_AUTO_MONITOR: 
            case FX_TRACK_7_SET_AUTO_MONITOR: 
            case FX_TRACK_8_SET_AUTO_MONITOR: {
                if (!isButtonPressed) break;
                ((ITrack)effectTrackBank.getItem(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_AUTO_MONITOR.ordinal())).setAutoMonitor(value.isPositive());
                break;
            }
            case FX_TRACK_1_SET_SEND_1: 
            case FX_TRACK_2_SET_SEND_1: 
            case FX_TRACK_3_SET_SEND_1: 
            case FX_TRACK_4_SET_SEND_1: 
            case FX_TRACK_5_SET_SEND_1: 
            case FX_TRACK_6_SET_SEND_1: 
            case FX_TRACK_7_SET_SEND_1: 
            case FX_TRACK_8_SET_SEND_1: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_1.ordinal(), 0, knobMode, value);
                break;
            }
            case FX_TRACK_1_SET_SEND_2: 
            case FX_TRACK_2_SET_SEND_2: 
            case FX_TRACK_3_SET_SEND_2: 
            case FX_TRACK_4_SET_SEND_2: 
            case FX_TRACK_5_SET_SEND_2: 
            case FX_TRACK_6_SET_SEND_2: 
            case FX_TRACK_7_SET_SEND_2: 
            case FX_TRACK_8_SET_SEND_2: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_2.ordinal(), 1, knobMode, value);
                break;
            }
            case FX_TRACK_1_SET_SEND_3: 
            case FX_TRACK_2_SET_SEND_3: 
            case FX_TRACK_3_SET_SEND_3: 
            case FX_TRACK_4_SET_SEND_3: 
            case FX_TRACK_5_SET_SEND_3: 
            case FX_TRACK_6_SET_SEND_3: 
            case FX_TRACK_7_SET_SEND_3: 
            case FX_TRACK_8_SET_SEND_3: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_3.ordinal(), 2, knobMode, value);
                break;
            }
            case FX_TRACK_1_SET_SEND_4: 
            case FX_TRACK_2_SET_SEND_4: 
            case FX_TRACK_3_SET_SEND_4: 
            case FX_TRACK_4_SET_SEND_4: 
            case FX_TRACK_5_SET_SEND_4: 
            case FX_TRACK_6_SET_SEND_4: 
            case FX_TRACK_7_SET_SEND_4: 
            case FX_TRACK_8_SET_SEND_4: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_4.ordinal(), 3, knobMode, value);
                break;
            }
            case FX_TRACK_1_SET_SEND_5: 
            case FX_TRACK_2_SET_SEND_5: 
            case FX_TRACK_3_SET_SEND_5: 
            case FX_TRACK_4_SET_SEND_5: 
            case FX_TRACK_5_SET_SEND_5: 
            case FX_TRACK_6_SET_SEND_5: 
            case FX_TRACK_7_SET_SEND_5: 
            case FX_TRACK_8_SET_SEND_5: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_5.ordinal(), 4, knobMode, value);
                break;
            }
            case FX_TRACK_1_SET_SEND_6: 
            case FX_TRACK_2_SET_SEND_6: 
            case FX_TRACK_3_SET_SEND_6: 
            case FX_TRACK_4_SET_SEND_6: 
            case FX_TRACK_5_SET_SEND_6: 
            case FX_TRACK_6_SET_SEND_6: 
            case FX_TRACK_7_SET_SEND_6: 
            case FX_TRACK_8_SET_SEND_6: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_6.ordinal(), 5, knobMode, value);
                break;
            }
            case FX_TRACK_1_SET_SEND_7: 
            case FX_TRACK_2_SET_SEND_7: 
            case FX_TRACK_3_SET_SEND_7: 
            case FX_TRACK_4_SET_SEND_7: 
            case FX_TRACK_5_SET_SEND_7: 
            case FX_TRACK_6_SET_SEND_7: 
            case FX_TRACK_7_SET_SEND_7: 
            case FX_TRACK_8_SET_SEND_7: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_7.ordinal(), 6, knobMode, value);
                break;
            }
            case FX_TRACK_1_SET_SEND_8: 
            case FX_TRACK_2_SET_SEND_8: 
            case FX_TRACK_3_SET_SEND_8: 
            case FX_TRACK_4_SET_SEND_8: 
            case FX_TRACK_5_SET_SEND_8: 
            case FX_TRACK_6_SET_SEND_8: 
            case FX_TRACK_7_SET_SEND_8: 
            case FX_TRACK_8_SET_SEND_8: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.FX_TRACK_1_SET_SEND_8.ordinal(), 7, knobMode, value);
                break;
            }
            case FX_TRACK_SELECTED_SET_SEND_1: 
            case FX_TRACK_SELECTED_SET_SEND_2: 
            case FX_TRACK_SELECTED_SET_SEND_3: 
            case FX_TRACK_SELECTED_SET_SEND_4: 
            case FX_TRACK_SELECTED_SET_SEND_5: 
            case FX_TRACK_SELECTED_SET_SEND_6: 
            case FX_TRACK_SELECTED_SET_SEND_7: 
            case FX_TRACK_SELECTED_SET_SEND_8: {
                this.changeSendVolume(-1, command.ordinal() - FlexiCommand.FX_TRACK_SELECTED_SET_SEND_1.ordinal(), knobMode, value);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private int getSendValue(int trackIndex, int sendIndex) {
        Optional<ITrack> track = this.getTrack(trackIndex);
        if (track.isEmpty()) {
            return 0;
        }
        ISendBank sendBank = track.get().getSendBank();
        if (sendIndex >= sendBank.getPageSize()) {
            return 0;
        }
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (send == null) {
            return 0;
        }
        return send.getValue();
    }

    private Optional<ITrack> getTrack(int trackIndex) {
        ITrackBank tb = this.model.getEffectTrackBank();
        if (trackIndex < 0) {
            return tb.getSelectedItem();
        }
        ITrack track = (ITrack)tb.getItem(trackIndex);
        return track.doesExist() ? Optional.of(track) : Optional.empty();
    }

    private void changeTrackVolume(KnobMode knobMode, int trackIndex, MidiValue value) {
        Optional<ITrack> track = this.getTrack(trackIndex);
        if (track.isEmpty()) {
            return;
        }
        int val = value.getValue();
        IParameter volumeParameter = track.get().getVolumeParameter();
        if (FxTrackHandler.isAbsolute(knobMode)) {
            volumeParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            volumeParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void changeTrackPanning(KnobMode knobMode, int trackIndex, MidiValue value) {
        Optional<ITrack> track = this.getTrack(trackIndex);
        if (track.isEmpty()) {
            return;
        }
        IParameter panParameter = track.get().getPanParameter();
        int val = value.getValue();
        if (FxTrackHandler.isAbsolute(knobMode)) {
            panParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            panParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void changeSendVolume(int trackIndex, int sendIndex, KnobMode knobMode, MidiValue value) {
        Optional<ITrack> track = this.getTrack(trackIndex);
        if (track.isEmpty()) {
            return;
        }
        ISendBank sendBank = track.get().getSendBank();
        if (sendIndex >= sendBank.getPageSize()) {
            return;
        }
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (send == null) {
            return;
        }
        int val = value.getValue();
        if (FxTrackHandler.isAbsolute(knobMode)) {
            send.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            send.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void scrollTrack(KnobMode knobMode, MidiValue value) {
        if (FxTrackHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        if (this.isIncrease(knobMode, value)) {
            this.scrollTrackRight(false);
        } else {
            this.scrollTrackLeft(false);
        }
    }

    private void scrollTrackLeft(boolean switchBank) {
        int index;
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional sel = tb.getSelectedItem();
        int n = index = sel.isEmpty() ? 0 : ((ITrack)sel.get()).getIndex() - 1;
        if (index == -1 || switchBank) {
            tb.selectPreviousPage();
            return;
        }
        ((ITrack)tb.getItem(index)).select();
    }

    private void scrollTrackRight(boolean switchBank) {
        int index;
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional sel = tb.getSelectedItem();
        int n = index = sel.isEmpty() ? 0 : ((ITrack)sel.get()).getIndex() + 1;
        if (index == 8 || switchBank) {
            tb.selectNextPage();
            return;
        }
        ((ITrack)tb.getItem(index)).select();
    }
}

