/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.faderfox.ec4.controller;

import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class EC4Display
extends AbstractTextDisplay {
    public static final int DISPLAY_CONTROLS = 0;
    public static final int DISPLAY_TOTAL = 3;
    private static final byte[] SYSEX_HEADER = new byte[]{-16, 0, 0, 0, 78, 44, 27};
    private final int display;

    public EC4Display(IHost host, IMidiOutput output, int display) {
        super(host, output, 4, display == 3 ? 5 : 4, display == 3 ? 20 : 16);
        this.display = display;
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        if (text.equals(previousText)) {
            return;
        }
        Map<Integer, String> diff = EC4Display.calculateDiff(text, previousText);
        if (diff.isEmpty()) {
            return;
        }
        int rowOffset = this.noOfCharacters * row;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(SYSEX_HEADER);
            out.write(78);
            out.write(34);
            out.write((byte)(16 + this.display));
            for (Map.Entry<Integer, String> e : diff.entrySet()) {
                int offset = rowOffset + e.getKey();
                String token = e.getValue();
                out.write(74);
                out.write(32 + offset / 16);
                out.write(16 + offset % 16);
                for (int i = 0; i < token.length(); ++i) {
                    byte ascii = (byte)token.charAt(i);
                    out.write(77);
                    out.write(32 + ascii / 16);
                    out.write(16 + ascii % 16);
                }
            }
            out.write(-9);
            this.output.sendSysex(new byte[][]{out.toByteArray()});
        }
        catch (IOException ex) {
            this.host.error("Could not send sysex command.", ex);
        }
    }

    private static Map<Integer, String> calculateDiff(String text, String previousText) {
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        if (previousText == null || previousText.isBlank()) {
            result.put(0, text);
            return result;
        }
        int length = Math.max(previousText.length(), text.length());
        String textOld = StringUtils.pad(previousText, length);
        String textNew = StringUtils.pad(text, length);
        int position = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char character = textNew.charAt(i);
            if (character == textOld.charAt(i)) {
                if (sb.length() > 0) {
                    result.put(position, sb.toString());
                    sb.setLength(0);
                }
                position = i + 1;
                continue;
            }
            sb.append(character);
        }
        if (sb.length() > 0) {
            result.put(position, sb.toString());
        }
        return result;
    }

    @Override
    public void shutdown() {
    }

    public void setTotalDisplayVisible(boolean isVisible) {
        this.sendSysex(new byte[]{78, 34, (byte)(isVisible ? 20 : 21)});
    }

    private void sendSysex(byte[] content) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(SYSEX_HEADER);
            out.write(content);
            out.write(-9);
            this.output.sendSysex(new byte[][]{out.toByteArray()});
        }
        catch (IOException ex) {
            this.host.error("Could not send sysex command.", ex);
        }
    }
}

