/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.controller;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class APCPadGrid
extends PadGridImpl {
    private final boolean isMkII;

    public APCPadGrid(ColorManager colorManager, IMidiOutput output, boolean isMkII) {
        super(colorManager, output, 5, 8, 36);
        this.isMkII = isMkII;
    }

    @Override
    protected void sendBlinkState(int channel, int note, int blinkColor, boolean fast) {
        if (this.isMkII) {
            this.output.sendNoteEx(fast ? 12 : 10, note, blinkColor);
        } else {
            this.output.sendNoteEx(channel, note, blinkColor);
        }
    }

    @Override
    public int translateToGrid(int note) {
        return note + 36;
    }

    @Override
    public int[] translateToController(int note) {
        int n = note - 36;
        if (this.isMkII) {
            return new int[]{0, n};
        }
        return new int[]{n % 8, 57 - n / 8};
    }
}

