/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.acvs;

import de.mossgrabers.controller.akai.acvs.ACVSConfiguration;
import de.mossgrabers.controller.akai.acvs.ACVSDevice;
import de.mossgrabers.controller.akai.acvs.command.trigger.ACVSMasterCommand;
import de.mossgrabers.controller.akai.acvs.controller.ACVSColorManager;
import de.mossgrabers.controller.akai.acvs.controller.ACVSControlSurface;
import de.mossgrabers.controller.akai.acvs.mode.ControlMode;
import de.mossgrabers.controller.akai.acvs.view.ControlView;
import de.mossgrabers.framework.command.continuous.LoopLengthCommand;
import de.mossgrabers.framework.command.continuous.LoopPositionCommand;
import de.mossgrabers.framework.command.continuous.PlayPositionCommand;
import de.mossgrabers.framework.command.core.NopCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.ShiftCommand;
import de.mossgrabers.framework.command.trigger.application.DuplicateCommand;
import de.mossgrabers.framework.command.trigger.application.LoadCommand;
import de.mossgrabers.framework.command.trigger.application.OverdubCommand;
import de.mossgrabers.framework.command.trigger.application.PanelLayoutCommand;
import de.mossgrabers.framework.command.trigger.application.SaveCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.mode.ButtonRowModeCommand;
import de.mossgrabers.framework.command.trigger.mode.CursorCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeSelectCommand;
import de.mossgrabers.framework.command.trigger.transport.AutomationCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.command.trigger.transport.RestartCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.constants.LaunchQuantization;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.track.TrackCrossfadeAMode;
import de.mossgrabers.framework.mode.track.TrackCrossfadeBMode;
import de.mossgrabers.framework.mode.track.TrackMuteMode;
import de.mossgrabers.framework.mode.track.TrackRecArmMode;
import de.mossgrabers.framework.mode.track.TrackSoloMode;
import de.mossgrabers.framework.mode.track.TrackStopClipMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.Arrays;
import java.util.Optional;

public class ACVSControllerSetup
extends AbstractControllerSetup<ACVSControlSurface, ACVSConfiguration> {
    private final boolean[] noteBlocker = new boolean[64];

    public ACVSControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        Arrays.fill(this.noteBlocker, false);
        this.colorManager = new ACVSColorManager();
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new ACVSConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.setHasFullFlatTrackList(true);
        ms.setNumSends(4);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        this.model.getTrackBank().setIndication(true);
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 52, 4, 4);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput(null, new String[0]);
        midiAccess.createInput(1, "Pads (Remote MIDI Port)", "8?????", "9?????", "A?????");
        ACVSControlSurface surface = new ACVSControlSurface(this.host, this.colorManager, (ACVSConfiguration)this.configuration, output, input);
        this.surfaces.add(surface);
        surface.setITextMessageHandler((itemID, text) -> {
            if (itemID == 768) {
                try {
                    this.model.getTransport().setTempo(Double.parseDouble(text));
                }
                catch (NumberFormatException ex) {
                    this.host.error("Illegal tempo format: " + text);
                }
            } else {
                surface.errorln("Unknown text message: " + itemID);
            }
        });
    }

    @Override
    protected void createModes() {
        ACVSControlSurface surface = (ACVSControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.USER, new ControlMode(surface, this.model));
        ModeManager trackModeManager = surface.getTrackModeManager();
        trackModeManager.register(Modes.MUTE, new TrackMuteMode(surface, this.model));
        trackModeManager.register(Modes.SOLO, new TrackSoloMode(surface, this.model));
        trackModeManager.register(Modes.REC_ARM, new TrackRecArmMode(surface, this.model));
        trackModeManager.register(Modes.STOP_CLIP, new TrackStopClipMode(surface, this.model));
        trackModeManager.register(Modes.CROSSFADE_MODE_A, new TrackCrossfadeAMode(surface, this.model));
        trackModeManager.register(Modes.CROSSFADE_MODE_B, new TrackCrossfadeBMode(surface, this.model));
    }

    @Override
    protected void createViews() {
        ACVSControlSurface surface = (ACVSControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.CONTROL, new ControlView(surface, this.model));
    }

    @Override
    protected void registerTriggerCommands() {
        ITrackBank tb = this.model.getTrackBank();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        ACVSControlSurface surface = (ACVSControlSurface)this.getSurface();
        boolean isForce = ((ACVSConfiguration)this.configuration).isActiveACVSDevice(ACVSDevice.FORCE);
        for (int i = 0; i < 8; ++i) {
            ButtonID selectID = ButtonID.get(ButtonID.ROW_SELECT_1, i);
            String label = "Track Select " + (i + 1);
            int index = i;
            this.addReceiveButton(selectID, label, () -> ((ITrack)tb.getItem(index)).selectOrExpandGroup(), 0, 0 + i);
            ButtonID stopID = ButtonID.get(ButtonID.ROW1_1, i);
            label = "Track Stop " + (i + 1);
            this.addReceiveButton(stopID, label, () -> ((ITrack)tb.getItem(index)).stop(surface.isShiftPressed()), 0, 16 + i);
            int j = 0;
            while (j < 8) {
                int pos = i + j * 8;
                ButtonID padID = ButtonID.get(ButtonID.PAD20, pos);
                label = "Pad " + (pos + 1);
                int slotIndex = j++;
                int midiControl = 24 + pos;
                this.addReceiveButton(padID, label, (ButtonEvent event, int velocity) -> this.handleClip(surface, index, slotIndex, event), 0, midiControl);
            }
            ButtonID sceneID = ButtonID.get(ButtonID.SCENE1, i);
            label = "Scene " + (i + 1);
            ISceneBank sceneBank = this.model.getSceneBank();
            this.addReceiveButton(sceneID, label, (ButtonEvent event, int velocity) -> this.handleScene(surface, (IScene)sceneBank.getItem(index), event), 0, 88 + i);
            ButtonID soloID = ButtonID.get(ButtonID.ROW2_1, i);
            label = "Solo " + (i + 1);
            this.addReceiveButton(soloID, label, () -> ((ITrack)tb.getItem(index)).toggleSolo(), i + 1, 0);
            ButtonID muteID = ButtonID.get(ButtonID.ROW3_1, i);
            label = "Mute " + (i + 1);
            this.addReceiveButton(muteID, label, () -> ((ITrack)tb.getItem(index)).toggleMute(), i + 1, 1);
            ButtonID crossfaderID = ButtonID.get(ButtonID.ROW4_1, i);
            label = "Crossfader " + (i + 1);
            this.addReceiveButton(crossfaderID, label, (ButtonEvent event, int velocity) -> {
                if (event == ButtonEvent.LONG) {
                    return;
                }
                int v = 63;
                if (event == ButtonEvent.DOWN) {
                    if (velocity == 1) {
                        v = 0;
                    } else if (velocity == 2) {
                        v = 127;
                    }
                }
                ((ITrack)tb.getItem(index)).getCrossfadeParameter().setValue(v);
            }, i + 1, 4);
            ButtonID recArmID = ButtonID.get(ButtonID.ROW5_1, i);
            label = "Rec Arm " + (i + 1);
            this.addReceiveButton(recArmID, label, () -> ((ITrack)tb.getItem(index)).toggleRecArm(), i + 1, 5);
        }
        this.addReceiveButton(ButtonID.DEVICE_ON_OFF, "Device on/off", cursorDevice::toggleEnabledState, 9, 0, true);
        this.addReceiveButton(ButtonID.DEVICE_LEFT, "Device prev", cursorDevice::selectPrevious, 9, 1);
        this.addReceiveButton(ButtonID.DEVICE_RIGHT, "Device next", cursorDevice::selectNext, 9, 2);
        this.addReceiveButton(ButtonID.BANK_LEFT, "Bank prev", () -> cursorDevice.getParameterBank().selectPreviousItem(), 9, 3);
        this.addReceiveButton(ButtonID.BANK_RIGHT, "Bank next", () -> cursorDevice.getParameterBank().selectNextItem(), 9, 4);
        this.registerMPCTouchDisplayTriggerCommands(surface, cursorDevice, tb);
        if (isForce) {
            this.registerForceTriggerCommands(surface, tb);
        } else {
            this.registerMPCTriggerCommands(surface, cursorDevice, tb);
        }
    }

    protected void handleClip(ACVSControlSurface surface, int trackIndex, int slotIndex, ButtonEvent event) {
        if (event == ButtonEvent.LONG) {
            return;
        }
        ISlot slot = (ISlot)((ITrack)this.model.getTrackBank().getItem(trackIndex)).getSlotBank().getItem(slotIndex);
        if (!slot.doesExist()) {
            return;
        }
        if (event == ButtonEvent.DOWN) {
            slot.select();
            if (surface.isSelectPressed()) {
                return;
            }
            if (surface.isPressed(ButtonID.F2)) {
                slot.remove();
                return;
            }
            if (surface.isPressed(ButtonID.DUPLICATE)) {
                surface.setTriggerConsumed(ButtonID.DUPLICATE);
                slot.duplicate();
                return;
            }
        }
        slot.launch(event == ButtonEvent.DOWN, surface.isShiftPressed());
    }

    protected void handleScene(ACVSControlSurface surface, IScene scene, ButtonEvent event) {
        boolean isPressed;
        if (event == ButtonEvent.LONG) {
            return;
        }
        boolean bl = isPressed = event == ButtonEvent.DOWN;
        if (isPressed) {
            if (surface.isPressed(ButtonID.F2)) {
                scene.remove();
                return;
            }
            if (surface.isPressed(ButtonID.DUPLICATE)) {
                surface.setTriggerConsumed(ButtonID.DUPLICATE);
                scene.duplicate();
                return;
            }
            scene.select();
            if (surface.isSelectPressed()) {
                return;
            }
        }
        scene.launch(isPressed, surface.isShiftPressed());
    }

    private void registerMPCTouchDisplayTriggerCommands(ACVSControlSurface surface, ICursorDevice cursorDevice, ITrackBank tb) {
        ITransport transport = this.model.getTransport();
        this.addReceiveButton(ButtonID.METRONOME, "Metronome", transport::toggleMetronome, 10, 0, true);
        this.addReceiveButton(ButtonID.F4, "Overdub", () -> {
            if (surface.isShiftPressed()) {
                transport.toggleLauncherOverdub();
            } else {
                transport.toggleOverdub();
            }
        }, 10, 3, true);
        this.addReceiveButton(ButtonID.AUTOMATION_WRITE, "Automation", () -> {
            if (surface.isShiftPressed()) {
                transport.toggleWriteClipLauncherAutomation();
            } else {
                transport.toggleWriteArrangerAutomation();
            }
        }, 10, 4, true);
        this.addReceiveButton(ButtonID.LOOP, "Loop", transport::toggleLoop, 10, 5, true);
        this.addReceiveButton(ButtonID.LAUNCH_QUANTIZATION, "Launch Quantize", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN || event == ButtonEvent.UP) {
                transport.setDefaultLaunchQuantization(ACVSControllerSetup.convertLaunchQuantization(velocity));
            }
        }, 10, 6);
        this.addReceiveButton(ButtonID.LAYOUT_ARRANGE, "Arrange / Session", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                this.model.getApplication().setPanelLayout(velocity == 0 ? "ARRANGE" : "MIX");
            }
        }, 10, 7);
        this.addReceiveButton(ButtonID.FOLLOW, "Follow", this.model.getArranger()::togglePlaybackFollow, 10, 8, true);
        this.addReceiveButton(ButtonID.PIN_DEVICE, "Pin Device", cursorDevice::togglePinned, 10, 10, true);
        this.addReceiveButton(ButtonID.NUDGE_MINUS, "Nudge Down", () -> transport.setTempo(transport.getTempo() - 1.0), 10, 12, false);
        this.addReceiveButton(ButtonID.NUDGE_PLUS, "Nudge Up", () -> transport.setTempo(transport.getTempo() + 1.0), 10, 13, false);
        this.addReceiveButton(ButtonID.DELETE, "Delete", () -> {
            Optional selectedTrack = tb.getSelectedItem();
            if (selectedTrack.isEmpty()) {
                return;
            }
            Optional selectedSlot = ((ITrack)selectedTrack.get()).getSlotBank().getSelectedItem();
            if (selectedSlot.isPresent()) {
                ((ISlot)selectedSlot.get()).remove();
            }
        }, 10, 14, true);
        this.addButton(surface, ButtonID.F3, "QUANTIZE INTERVAL", (ButtonEvent event, int velocity) -> {
            if (event != ButtonEvent.LONG) {
                int quant = (10 - velocity) * 10;
                ((ACVSConfiguration)this.configuration).setQuantizeAmount(quant);
            }
        }, 10, 15, -1, false, null, new String[0]);
        this.addReceiveButton(ButtonID.QUANTIZE, "Quantize", () -> this.model.getCursorClip().quantize((double)((ACVSConfiguration)this.configuration).getQuantizeAmount() / 100.0), 10, 16, true);
        this.addReceiveButton(ButtonID.STOP_ALL_CLIPS, "Stop all clips", () -> tb.stop(surface.isShiftPressed()), 10, 20);
        this.addReceiveButton(ButtonID.INSERT_SCENE, "Insert scene", this.model.getProject()::createScene, 10, 21);
        NewCommand newCommand = new NewCommand(this.model, surface);
        this.addReceiveButton(ButtonID.NEW, "REC (New)", newCommand::execute, 10, 22, false);
    }

    private void registerMPCTriggerCommands(ACVSControlSurface surface, ICursorDevice cursorDevice, ITrackBank tb) {
        ISceneBank sceneBank = this.model.getSceneBank();
        ITransport transport = this.model.getTransport();
        this.addButton(ButtonID.ARROW_DOWN, "Bank A", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                sceneBank.selectNextPage();
            }
        }, 12, 107);
        this.addButton(ButtonID.ARROW_UP, "Bank B", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                sceneBank.selectPreviousPage();
            }
        }, 12, 106);
        this.addButton(ButtonID.ARROW_LEFT, "Bank C", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                tb.selectPreviousPage();
            }
        }, 12, 108);
        this.addButton(ButtonID.ARROW_RIGHT, "Bank D", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                tb.selectNextPage();
            }
        }, 12, 109);
        this.addButton(ButtonID.REPEAT, "NOTE REPEAT", new PanelLayoutCommand(this.model, surface), 12, 68, cursorDevice::isWindowOpen);
        this.addButton(ButtonID.AUTOMATION, "FULL LEVEL", new AutomationCommand(this.model, surface), 12, 69, () -> {
            if (surface.isShiftPressed()) {
                return transport.isWritingClipLauncherAutomation() ? 1 : 0;
            }
            return transport.isWritingArrangerAutomation() ? 2 : 0;
        }, "BUTTON_STATE_OFF", "BUTTON_UNDO_STATE_ON", "BUTTON_UNDO_STATE_HI");
        this.addButton(ButtonID.CLIP, "16 LEVEL", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                boolean launchClips = !((ACVSConfiguration)this.configuration).isLaunchClips();
                ((ACVSConfiguration)this.configuration).setLaunchClipsOrScenes(launchClips);
                this.host.showNotification("Launch " + (launchClips ? "Clips" : "Scenes"));
            }
        }, 12, 70, () -> ((ACVSConfiguration)this.configuration).isLaunchClips() ? 0 : 1, "BUTTON_STATE_ON", "BUTTON_UNDO_STATE_ON");
        this.addButton(ButtonID.F2, "ERASE", (TriggerCommand)NopCommand.INSTANCE, 12, 71);
        this.addButton(ButtonID.SHIFT, "SHIFT", new ShiftCommand(this.model, surface), 12, 72);
        this.addButton(ButtonID.UNDO, "Undo", new UndoCommand(this.model, surface), 12, 74, () -> {
            if (surface.isShiftPressed() ? !this.model.getApplication().canRedo() : !this.model.getApplication().canUndo()) {
                return 0;
            }
            return surface.getButton(ButtonID.UNDO).isPressed() ? 2 : 1;
        }, "BUTTON_STATE_OFF", "BUTTON_UNDO_STATE_ON", "BUTTON_UNDO_STATE_HI");
        this.addButton(ButtonID.DUPLICATE, "COPY", new DuplicateCommand(this.model, surface), 12, 75);
        this.addButton(ButtonID.TAP_TEMPO, "Tap Tempo", new TapTempoCommand(this.model, surface), 12, 76, () -> surface.isPressed(ButtonID.TAP_TEMPO) ? 1 : 0, "BUTTON_UNDO_STATE_ON", "BUTTON_UNDO_STATE_HI");
        this.addButton(ButtonID.RECORD, "REC", new RecordCommand(this.model, surface), 12, 77, transport::isRecording);
        this.addButton(ButtonID.OVERDUB, "OVERDUB", new OverdubCommand(this.model, surface), 12, 78, () -> surface.isShiftPressed() ? transport.isLauncherOverdub() : transport.isArrangerOverdub());
        this.addButton(ButtonID.STOP, "STOP", new StopCommand(this.model, surface), 12, 79, () -> !transport.isPlaying());
        this.addButton(ButtonID.PLAY, "PLAY", new PlayCommand(this.model, surface), 12, 80, transport::isPlaying);
        this.addButton(ButtonID.RETURN_TO_ZERO, "PLAY START", new RestartCommand(this.model, surface), 12, 81);
        for (int i = 0; i < 64; ++i) {
            int trackIndex = i % 8;
            int clipIndex = i / 8;
            int noteIndex = i;
            this.addButton(surface, ButtonID.get(ButtonID.MORE_PADS1, i), "PAD " + (i + 1), (ButtonEvent event, int velocity) -> {
                if (event == ButtonEvent.DOWN) {
                    if (this.noteBlocker[noteIndex]) {
                        return;
                    }
                    this.noteBlocker[noteIndex] = true;
                }
                if (event == ButtonEvent.UP) {
                    this.noteBlocker[noteIndex] = false;
                }
                if (((ACVSConfiguration)this.configuration).isLaunchClips()) {
                    this.handleClip(surface, trackIndex, clipIndex, event);
                    return;
                }
                if (clipIndex < 2) {
                    IScene scene = (IScene)this.model.getSceneBank().getItem(clipIndex * 4 + trackIndex);
                    this.handleScene(surface, scene, event);
                }
            }, 12, 0 + i, -1, false, null, new String[0]);
        }
    }

    private void registerForceTriggerCommands(ACVSControlSurface surface, ITrackBank tb) {
        int trackIndex;
        int i;
        ITrackBank trackBank = this.model.getTrackBank();
        ITransport transport = this.model.getTransport();
        ModeManager trackModeManager = surface.getTrackModeManager();
        for (i = 0; i < 8; ++i) {
            trackIndex = i;
            this.addButton(surface, ButtonID.get(ButtonID.TRACK_SELECT_1, i), "TRACK SELECT " + (i + 1), (ButtonEvent event, int velocity) -> {
                if (event != ButtonEvent.DOWN) {
                    return;
                }
                if (surface.isShiftPressed()) {
                    LaunchQuantization launchQuantization = LaunchQuantization.values()[trackIndex];
                    transport.setDefaultLaunchQuantization(launchQuantization);
                    this.host.showNotification("Launch Quantization: " + launchQuantization.getName());
                    return;
                }
                ITrack track = (ITrack)trackBank.getItem(trackIndex);
                if (surface.isPressed(ButtonID.F2)) {
                    track.remove();
                } else if (surface.isPressed(ButtonID.DUPLICATE)) {
                    surface.setTriggerConsumed(ButtonID.DUPLICATE);
                    track.duplicate();
                } else {
                    track.selectOrExpandGroup();
                }
            }, 12, 0 + i, -1, false, null, new String[0]);
            ButtonRowModeCommand rowModeCommand = new ButtonRowModeCommand(trackModeManager, 0, trackIndex, this.model, surface);
            this.addButton(surface, ButtonID.get(ButtonID.TRACK_ASSIGN_1, i), "TRACK ASSIGN " + (i + 1), (ButtonEvent event, int velocity) -> {
                if (surface.isShiftPressed()) {
                    if (event != ButtonEvent.DOWN) {
                        return;
                    }
                    switch (trackIndex) {
                        case 0: {
                            this.model.getCursorClip().quantize((double)((ACVSConfiguration)this.configuration).getQuantizeAmount() / 100.0);
                            break;
                        }
                        case 1: {
                            new NewCommand(this.model, surface).execute();
                            break;
                        }
                        case 2: {
                            this.model.getCursorClip().duplicateContent();
                            break;
                        }
                        case 4: {
                            transport.toggleMetronome();
                            break;
                        }
                    }
                    return;
                }
                rowModeCommand.execute(event, velocity);
            }, 12, 8 + i, -1, false, null, new String[0]);
        }
        for (i = 0; i < 64; ++i) {
            trackIndex = i % 8;
            int clipIndex = i / 8;
            int noteIndex = i;
            this.addButton(surface, ButtonID.get(ButtonID.MORE_PADS1, i), "PAD " + (i + 1), (ButtonEvent event, int velocity) -> {
                if (event == ButtonEvent.DOWN) {
                    if (this.noteBlocker[noteIndex]) {
                        return;
                    }
                    this.noteBlocker[noteIndex] = true;
                }
                if (event == ButtonEvent.UP) {
                    this.noteBlocker[noteIndex] = false;
                }
                if (((ACVSConfiguration)this.configuration).isLaunchClips()) {
                    this.handleClip(surface, trackIndex, clipIndex, event);
                    return;
                }
                if (clipIndex < 2) {
                    IScene scene = (IScene)this.model.getSceneBank().getItem(clipIndex * 4 + trackIndex);
                    this.handleScene(surface, scene, event);
                }
            }, 12, 16 + i, -1, false, null, new String[0]);
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        for (int i2 = 0; i2 < 8; ++i2) {
            int index = i2;
            this.addButton(surface, ButtonID.get(ButtonID.ROW6_1, i2), "SCENE " + (i2 + 1), (ButtonEvent event, int velocity) -> this.handleScene(surface, (IScene)sceneBank.getItem(index), event), 12, 80 + i2, -1, false, null, new String[0]);
        }
        this.addButton(ButtonID.MASTERTRACK, "MASTER", new ACVSMasterCommand(this.model, surface), 12, 88, () -> this.model.getMasterTrack().isSelected());
        this.addButton(ButtonID.F5, "STOP ALL CLIPS", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                trackBank.stop(surface.isShiftPressed());
            }
        }, 12, 89);
        this.addButton(ButtonID.SESSION, "LAUNCH", (TriggerCommand)NopCommand.INSTANCE, 12, 91);
        this.addButton(ButtonID.NOTE, "NOTE", (TriggerCommand)NopCommand.INSTANCE, 12, 92);
        this.addButton(ButtonID.SEQUENCER, "SEQUENCER", (TriggerCommand)NopCommand.INSTANCE, 12, 93);
        this.addButton(ButtonID.SELECT, "SELECT", (TriggerCommand)NopCommand.INSTANCE, 12, 94);
        this.addButton(ButtonID.NOTE_EDITOR, "EDIT", (TriggerCommand)NopCommand.INSTANCE, 12, 95);
        this.addButton(ButtonID.DUPLICATE, "COPY", new DuplicateCommand(this.model, surface), 12, 96);
        this.addButton(ButtonID.F2, "ERASE", (TriggerCommand)NopCommand.INSTANCE, 12, 97);
        this.addButton(ButtonID.REPEAT, "ARP", (TriggerCommand)NopCommand.INSTANCE, 12, 98);
        this.addButton(ButtonID.TAP_TEMPO, "Tap Tempo", new TapTempoCommand(this.model, surface), 12, 99, () -> surface.isPressed(ButtonID.TAP_TEMPO) ? 1 : 0, "BUTTON_UNDO_STATE_ON", "BUTTON_UNDO_STATE_HI");
        this.addButton(ButtonID.MUTE, "MUTE", new ModeSelectCommand(trackModeManager, this.model, surface, Modes.MUTE), 12, 100, () -> trackModeManager.isActive(new Modes[]{Modes.MUTE}));
        this.addButton(ButtonID.SOLO, "SOLO", new ModeSelectCommand(trackModeManager, this.model, surface, Modes.SOLO), 12, 101, () -> trackModeManager.isActive(new Modes[]{Modes.SOLO}));
        this.addButton(ButtonID.REC_ARM, "REC ARM", new ModeSelectCommand(trackModeManager, this.model, surface, Modes.REC_ARM), 12, 102, () -> trackModeManager.isActive(new Modes[]{Modes.REC_ARM}));
        this.addButton(ButtonID.STOP_CLIP, "STOP CLIP", new ModeSelectCommand(trackModeManager, this.model, surface, Modes.STOP_CLIP), 12, 103, () -> trackModeManager.isActive(new Modes[]{Modes.STOP_CLIP}));
        this.addButton(ButtonID.PLAY, "PLAY", new PlayCommand(this.model, surface), 12, 104, transport::isPlaying);
        this.addButton(ButtonID.STOP, "STOP", new StopCommand(this.model, surface), 12, 105, () -> !transport.isPlaying());
        this.addButton(ButtonID.RECORD, "REC", new RecordCommand(this.model, surface), 12, 106, transport::isRecording);
        this.addButton(ButtonID.UNDO, "UNDO", new UndoCommand(this.model, surface), 12, 107, () -> {
            if (surface.isShiftPressed() ? !this.model.getApplication().canRedo() : !this.model.getApplication().canUndo()) {
                return 0;
            }
            return surface.getButton(ButtonID.UNDO).isPressed() ? 2 : 1;
        }, "BUTTON_STATE_OFF", "BUTTON_UNDO_STATE_ON", "BUTTON_UNDO_STATE_HI");
        this.addButton(ButtonID.LOAD, "LOAD", new LoadCommand(this.model, surface), 12, 108);
        this.addButton(ButtonID.SAVE, "SAVE", new SaveCommand(this.model, surface), 12, 109);
        this.addButton(ButtonID.BROWSE, "NAVIGATE", (TriggerCommand)NopCommand.INSTANCE, 12, 113);
        this.addButton(ButtonID.SHIFT, "SHIFT", new ShiftCommand(this.model, surface), 12, 114);
        CursorCommand leftCommand = new CursorCommand(Direction.LEFT, this.model, surface, false);
        CursorCommand rightCommand = new CursorCommand(Direction.RIGHT, this.model, surface, false);
        CursorCommand upCommand = new CursorCommand(Direction.UP, this.model, surface, false);
        CursorCommand downCommand = new CursorCommand(Direction.DOWN, this.model, surface, false);
        this.addButton(ButtonID.ARROW_UP, "Up", upCommand, 12, 115, () -> upCommand.canScroll() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_UNDO_STATE_ON");
        this.addButton(ButtonID.ARROW_DOWN, "Down", downCommand, 12, 116, () -> downCommand.canScroll() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_UNDO_STATE_ON");
        this.addButton(ButtonID.ARROW_LEFT, "Left", leftCommand, 12, 117, () -> leftCommand.canScroll() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_UNDO_STATE_ON");
        this.addButton(ButtonID.ARROW_RIGHT, "Right", rightCommand, 12, 118, () -> rightCommand.canScroll() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_UNDO_STATE_ON");
        this.addButton(ButtonID.CROSSFADE_A, "Crossfade A", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                trackModeManager.setActive(Modes.CROSSFADE_MODE_A);
            } else if (event == ButtonEvent.UP && trackModeManager.isActive(new Modes[]{Modes.CROSSFADE_MODE_A})) {
                trackModeManager.restore();
            }
        }, 12, 119);
        this.addButton(ButtonID.CROSSFADE_B, "Crossfade B", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN) {
                trackModeManager.setActive(Modes.CROSSFADE_MODE_B);
            } else if (event == ButtonEvent.UP && trackModeManager.isActive(new Modes[]{Modes.CROSSFADE_MODE_B})) {
                trackModeManager.restore();
            }
        }, 12, 120);
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        return BindType.NOTE;
    }

    @Override
    protected void registerContinuousCommands() {
        ITrackBank tb = this.model.getTrackBank();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IParameterBank parameterBank = cursorDevice.getParameterBank();
        ACVSControlSurface surface = (ACVSControlSurface)this.getSurface();
        for (int i = 0; i < 8; ++i) {
            int index = i;
            ContinuousID contID = ContinuousID.get(ContinuousID.FADER1, i);
            String label = "Volume " + (i + 1);
            ITrack track = (ITrack)tb.getItem(index);
            ISendBank sendBank = track.getSendBank();
            IHwFader fader = this.addFader(contID, label, track::setVolume, BindType.CC, i + 1, 0);
            fader.setIndexInGroup(i);
            track.setVolumeIndication(true);
            contID = ContinuousID.get(ContinuousID.KNOB1, i);
            label = "Pan " + (i + 1);
            IHwAbsoluteKnob knob = this.addAbsoluteKnob(contID, label, track::setPan, BindType.CC, i + 1, 1);
            knob.setIndexInGroup(i);
            track.setPanIndication(true);
            contID = ContinuousID.get(ContinuousID.SEND1_KNOB1, i);
            label = "Send 1 - " + (i + 1);
            knob = this.addAbsoluteKnob(contID, label, value -> ((ISend)sendBank.getItem(0)).setValue(value), BindType.CC, i + 1, 3);
            knob.setIndexInGroup(i);
            ((ISend)sendBank.getItem(0)).setIndication(true);
            contID = ContinuousID.get(ContinuousID.SEND2_KNOB1, i);
            label = "Send 2 - " + (i + 1);
            knob = this.addAbsoluteKnob(contID, label, value -> ((ISend)sendBank.getItem(1)).setValue(value), BindType.CC, i + 1, 4);
            knob.setIndexInGroup(i);
            ((ISend)sendBank.getItem(1)).setIndication(true);
            contID = ContinuousID.get(ContinuousID.SEND3_KNOB1, i);
            label = "Send 3 - " + (i + 1);
            knob = this.addAbsoluteKnob(contID, label, value -> ((ISend)sendBank.getItem(2)).setValue(value), BindType.CC, i + 1, 5);
            knob.setIndexInGroup(i);
            ((ISend)sendBank.getItem(2)).setIndication(true);
            contID = ContinuousID.get(ContinuousID.SEND4_KNOB1, i);
            label = "Send 4 - " + (i + 1);
            knob = this.addAbsoluteKnob(contID, label, value -> ((ISend)sendBank.getItem(3)).setValue(value), BindType.CC, i + 1, 6);
            knob.setIndexInGroup(i);
            ((ISend)sendBank.getItem(3)).setIndication(true);
            contID = ContinuousID.get(ContinuousID.DEVICE_KNOB1, i);
            label = "Device Knob " + (i + 1);
            knob = this.addAbsoluteKnob(contID, label, value -> ((IParameter)parameterBank.getItem(index)).setValue(value), BindType.CC, 9, 0 + i);
            knob.setIndexInGroup(i);
            ((IParameter)parameterBank.getItem(index)).setIndication(true);
        }
        this.addRelativeKnob(ContinuousID.PLAY_POSITION, "Position", new PlayPositionCommand(this.model, surface), BindType.CC, 10, 0);
        this.addRelativeKnob(ContinuousID.MOVE_LOOP, "Loop Start", new LoopPositionCommand(this.model, surface), BindType.CC, 10, 1);
        this.addRelativeKnob(ContinuousID.LOOP_LENGTH, "Loop Length", new LoopLengthCommand(this.model, surface), BindType.CC, 10, 2);
        IMidiInput midiInput = surface.getMidiInput();
        for (int i = 0; i < 8; ++i) {
            int index = i;
            ContinuousID volumeKnobID = ContinuousID.get(ContinuousID.VOLUME_KNOB1, i);
            IHwRelativeKnob volumeKnob = this.addRelativeKnob(volumeKnobID, "Volume " + (i + 1), (int value) -> ((ITrack)tb.getItem(index)).changeVolume(value), BindType.CC, 13, i);
            volumeKnob.bindTouch((event, velocity) -> {
                if (event == ButtonEvent.LONG) {
                    return;
                }
                IParameter volumeParameter = ((ITrack)tb.getItem(index)).getVolumeParameter();
                boolean isBeingTouched = event == ButtonEvent.DOWN;
                volumeParameter.touchValue(isBeingTouched);
                if (isBeingTouched && surface.isPressed(ButtonID.F2)) {
                    volumeParameter.resetValue();
                }
            }, midiInput, BindType.NOTE, 13, i);
            volumeKnob.setIndexInGroup(i);
            ContinuousID paramKnobID = ContinuousID.get(ContinuousID.PARAM_KNOB1, i);
            IHwRelativeKnob paramKnob = this.addRelativeKnob(paramKnobID, "Param " + (i + 1), (int value) -> ((IParameter)cursorDevice.getParameterBank().getItem(index)).changeValue(value), BindType.CC, 13, 8 + i);
            paramKnob.bindTouch((event, velocity) -> {
                if (event == ButtonEvent.LONG) {
                    return;
                }
                IParameter parameter = (IParameter)cursorDevice.getParameterBank().getItem(index);
                boolean isBeingTouched = event == ButtonEvent.DOWN;
                parameter.touchValue(isBeingTouched);
                if (isBeingTouched && surface.isPressed(ButtonID.F2)) {
                    parameter.resetValue();
                }
            }, midiInput, BindType.NOTE, 13, 8 + i);
            paramKnob.setIndexInGroup(i);
        }
        this.addFader(ContinuousID.CROSSFADER, "Crossfader", null, BindType.CC, 13, 16, false).bind(this.model.getTransport().getCrossfadeParameter());
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((ACVSConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
    }

    @Override
    public void startup() {
        ACVSControlSurface surface = (ACVSControlSurface)this.getSurface();
        surface.getViewManager().setActive(Views.CONTROL);
        surface.getModeManager().setActive(Modes.USER);
        surface.getTrackModeManager().setActive(Modes.STOP_CLIP);
        this.host.scheduleTask(() -> {
            this.host.println("Disconnected.");
            surface.sendPing();
        }, 2000L);
    }

    private static LaunchQuantization convertLaunchQuantization(int launchQuantization) {
        switch (launchQuantization) {
            case 11: 
            case 12: 
            case 13: {
                return LaunchQuantization.RES_1_16;
            }
            case 9: 
            case 10: {
                return LaunchQuantization.RES_1_8;
            }
            case 7: 
            case 8: {
                return LaunchQuantization.RES_1_4;
            }
            case 5: 
            case 6: {
                return LaunchQuantization.RES_1_2;
            }
            case 4: {
                return LaunchQuantization.RES_1;
            }
            case 3: {
                return LaunchQuantization.RES_2;
            }
            case 2: {
                return LaunchQuantization.RES_4;
            }
            case 1: {
                return LaunchQuantization.RES_8;
            }
        }
        return LaunchQuantization.RES_NONE;
    }

    private void addReceiveButton(ButtonID buttonID, String label, ButtonExec exec, int midiChannel, int midiControl) {
        this.addReceiveButton(buttonID, label, exec, midiChannel, midiControl, false);
    }

    private void addReceiveButton(ButtonID buttonID, String label, ButtonExec exec, int midiChannel, int midiControl, boolean isUpDown) {
        this.addReceiveButton(buttonID, label, (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.DOWN || isUpDown && event == ButtonEvent.UP) {
                exec.exec();
            }
        }, midiChannel, midiControl);
    }

    private void addReceiveButton(ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl) {
        ACVSControlSurface surface = (ACVSControlSurface)this.getSurface();
        this.addButton(surface, buttonID, label, command, midiChannel, midiControl, -1, false, null, new String[0]);
    }

    @FunctionalInterface
    private static interface ButtonExec {
        public void exec();
    }
}

