/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ColorSelectMode;
import de.mossgrabers.framework.view.ColorView;
import de.mossgrabers.framework.view.Views;
import java.util.Optional;

public class DeviceLayerDetailsMode
extends BaseMode<ILayer> {
    public DeviceLayerDetailsMode(PushControlSurface surface, IModel model) {
        super("Layer details", surface, model, model.getCursorDevice().getLayerBank());
        ICursorDevice cursorDevice = model.getCursorDevice();
        ViewManager viewManager = surface.getViewManager();
        viewManager.addChangeListener((previousID, activeID) -> {
            ILayerBank bank;
            switch (activeID) {
                case DRUM: {
                    bank = cursorDevice.getDrumPadBank();
                    break;
                }
                case DRUM64: {
                    bank = this.model.getDrumDevice(64).getDrumPadBank();
                    break;
                }
                case COLOR: {
                    return;
                }
                default: {
                    bank = cursorDevice.getLayerBank();
                }
            }
            this.switchBanks(bank);
        });
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        Optional channelOpt = this.bank.getSelectedItem();
        if (channelOpt.isEmpty()) {
            return;
        }
        IChannel channel = (IChannel)channelOpt.get();
        switch (index) {
            case 0: {
                channel.toggleIsActivated();
                break;
            }
            case 2: {
                channel.toggleMute();
                break;
            }
            case 3: {
                channel.toggleSolo();
                break;
            }
            case 7: {
                ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
                ((ColorView)viewManager.get(Views.COLOR)).setMode(ColorSelectMode.MODE_LAYER);
                viewManager.setActive(Views.COLOR);
                break;
            }
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        switch (index) {
            case 6: {
                IBank iBank = this.bank;
                if (!(iBank instanceof IDrumPadBank)) break;
                IDrumPadBank drumPadBank = (IDrumPadBank)iBank;
                drumPadBank.clearMute();
                break;
            }
            case 7: {
                IBank iBank = this.bank;
                if (!(iBank instanceof IDrumPadBank)) break;
                IDrumPadBank drumPadBank = (IDrumPadBank)iBank;
                drumPadBank.clearSolo();
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        Optional channelOpt = this.bank.getSelectedItem();
        if (channelOpt.isEmpty()) {
            return super.getButtonColor(buttonID);
        }
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            IChannel channel = (IChannel)channelOpt.get();
            return this.colorManager.getColorIndex(switch (index) {
                case 0 -> channel.isActivated() ? "PUSH_YELLOW_MD" : "PUSH_YELLOW_LO";
                case 2 -> channel.isMute() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO";
                case 3 -> channel.isSolo() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO";
                case 7 -> "PUSH_GREEN_HI";
                default -> "PUSH_BLACK";
            });
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index >= 6) {
                return this.colorManager.getColorIndex(this.bank instanceof IDrumPadBank ? "BUTTON_COLOR2_ON" : "BUTTON_COLOR_OFF");
            }
            return this.isPushModern ? 0 : 0;
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        Optional channelOpt = this.bank.getSelectedItem();
        if (channelOpt.isEmpty()) {
            display.setRow(1, "                     Please selecta layer...                        ");
            return;
        }
        IChannel channel = (IChannel)channelOpt.get();
        String layerName = channel.getName();
        String firstBlock = "Layer: " + layerName;
        display.setBlock(0, 0, firstBlock);
        if (layerName.length() > 17) {
            display.setBlock(0, 1, firstBlock.substring(17).trim());
        }
        display.setCell(2, 0, "Active").setCell(3, 0, channel.isActivated() ? "On" : "Off");
        display.setCell(2, 1, "");
        display.setCell(3, 1, "");
        display.setCell(2, 2, "Mute").setCell(3, 2, channel.isMute() ? "On" : "Off");
        display.setCell(2, 3, "Solo").setCell(3, 3, channel.isSolo() ? "On" : "Off");
        display.setCell(2, 4, "");
        display.setCell(3, 4, "");
        display.setCell(2, 5, "");
        display.setCell(3, 5, "");
        if (this.bank instanceof IDrumPadBank) {
            display.setCell(0, 6, "Clr Mute");
            display.setCell(0, 7, "Clr Solo");
        }
        display.setCell(2, 7, "Select");
        display.setCell(3, 7, "Color");
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        Optional channelOpt = this.bank.getSelectedItem();
        if (channelOpt.isEmpty()) {
            display.setMessage(3, "Please select a layer...");
            return;
        }
        IChannel channel = (IChannel)channelOpt.get();
        display.addOptionElement("Layer: " + channel.getName(), "", false, "", "Active", channel.isActivated(), false);
        display.addEmptyElement();
        display.addOptionElement("", "", false, "", "Mute", channel.isMute(), false);
        display.addOptionElement("", "", false, "", "Solo", channel.isSolo(), false);
        display.addEmptyElement();
        display.addEmptyElement();
        if (this.bank instanceof IDrumPadBank) {
            display.addOptionElement("", "Clear Mute", false, "", "", false, false);
            display.addOptionElement("", "Clear Solo", false, "", "Select Color", false, false);
        } else {
            display.addEmptyElement();
            display.addEmptyElement();
        }
    }
}

