/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.device.DeviceParamsMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class DeviceChainsMode
extends DeviceParamsMode {
    public DeviceChainsMode(PushControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        if (event == ButtonEvent.UP) {
            ICursorDevice cd = this.model.getCursorDevice();
            if (!cd.doesExist()) {
                return;
            }
            String[] slotChains = cd.getSlotChains();
            if (index >= slotChains.length) {
                return;
            }
            cd.selectSlotChain(slotChains[index]);
            ((PushControlSurface)this.surface).getModeManager().setActive(Modes.DEVICE_PARAMS);
            return;
        }
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.get(ButtonID.ROW1_1, index));
        this.moveUp();
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            return super.getButtonColor(buttonID);
        }
        int existsColor = this.isPushModern ? 15 : 13;
        int offColor = this.isPushModern ? 0 : 0;
        String[] slotChains = this.model.getCursorDevice().getSlotChains();
        return index < slotChains.length ? existsColor : offColor;
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (!this.checkExists1(display, cd)) {
            return;
        }
        display.setBlock(2, 0, "Device Chains:").setBlock(2, 1, cd.getName());
        String[] slotChains = cd.getSlotChains();
        for (int i = 0; i < 8; ++i) {
            String bottomMenu = i < slotChains.length ? slotChains[i] : "";
            display.setCell(3, i, bottomMenu);
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (!this.checkExists2(display, cd)) {
            return;
        }
        String color = this.model.getCurrentTrackBank().getSelectedChannelColorEntry();
        ColorEx bottomMenuColor = DAWColor.getColorEntry(color);
        boolean hasPinning = this.model.getHost().supports(Capability.HAS_PINNING);
        String[] slotChains = cd.getSlotChains();
        for (int i = 0; i < 8; ++i) {
            boolean isTopMenuOn = this.getTopMenuEnablement(cd, hasPinning, i);
            String bottomMenu = i < slotChains.length ? slotChains[i] : "";
            String bottomMenuIcon = "";
            boolean isBottomMenuOn = i < slotChains.length;
            display.addParameterElement(this.hostMenu[i], isTopMenuOn, bottomMenu, "", bottomMenuColor, isBottomMenuOn, "", 0, "", false, -1);
        }
    }
}

