/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;

public class ScalesMode
extends BaseMode<IItem> {
    private final Scales scales;

    public ScalesMode(PushControlSurface surface, IModel model) {
        super("Scale", surface, model);
        this.scales = model.getScales();
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (index != 0 || !this.increaseKnobMovement()) {
            return;
        }
        this.scales.changeScale(value);
        this.update();
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 0) {
            if (this.isPushModern) {
                this.scales.nextScale();
            } else {
                this.scales.prevScale();
            }
        } else if (index > 0 && index < 7) {
            this.scales.setScaleOffsetByIndex(index - 1);
        }
        this.update();
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            if (index == 0) {
                return this.colorManager.getColorIndex("PUSH_ORANGE_LO");
            }
            if (index == 7) {
                return this.colorManager.getColorIndex("BUTTON_COLOR_OFF");
            }
            int offset = this.scales.getScaleOffsetIndex();
            return this.colorManager.getColorIndex(offset == index - 1 ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index == 0 || index == 7) {
                return this.isPushModern ? 10 : 10;
            }
            int offset = this.scales.getScaleOffsetIndex();
            return this.colorManager.getColorIndex(offset == index - 1 + 6 ? "BUTTON_COLOR2_HI" : "BUTTON_COLOR2_ON");
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index == 0) {
            if (this.isPushModern) {
                this.scales.prevScale();
            } else {
                this.scales.nextScale();
            }
        } else if (index == 7) {
            this.scales.toggleChromatic();
        } else {
            this.scales.setScaleOffsetByIndex(index + 5);
        }
        this.update();
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        int selIndex = this.scales.getScale().ordinal();
        int pos = 0;
        for (Pair<String, Boolean> p : Push1Display.createMenuList(4, Scale.getNames(), selIndex)) {
            display.setBlock(pos, 0, (p.getValue() != false ? Push1Display.SELECT_ARROW : " ") + p.getKey());
            ++pos;
        }
        display.setBlock(0, 3, this.scales.getRangeText());
        int offset = this.scales.getScaleOffsetIndex();
        for (int i = 0; i < 6; ++i) {
            display.setCell(2, i + 1, "  " + (offset == i ? Push1Display.SELECT_ARROW : " ") + Scales.BASES.get(i));
            display.setCell(3, i + 1, "  " + (offset == 6 + i ? Push1Display.SELECT_ARROW : " ") + Scales.BASES.get(6 + i));
        }
        display.setCell(3, 7, this.scales.isChromatic() ? "Chromatc" : "In Key");
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        int selIndex = this.scales.getScale().ordinal();
        display.addListElement(6, Scale.getNames(), selIndex);
        int offset = this.scales.getScaleOffsetIndex();
        String rangeText = this.scales.getRangeText();
        for (int i = 0; i < 6; ++i) {
            display.addOptionElement((String)(i == 3 ? "Note range: " + rangeText : ""), Scales.BASES.get(6 + i), offset == 6 + i, "", Scales.BASES.get(i), offset == i, false);
        }
        display.addOptionElement("", this.scales.isChromatic() ? "Chromatc" : "In Key", this.scales.isChromatic(), "", "", false, false);
    }

    private void update() {
        ((IView)((PushControlSurface)this.surface).getViewManager().getActive()).updateNoteMapping();
        this.scales.updateScaleProperties((Configuration)((PushControlSurface)this.surface).getConfiguration());
    }
}

