/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.nativefiledialogs;

import com.sun.jna.Platform;
import de.mossgrabers.nativefiledialogs.NativeFileDialogs;
import de.mossgrabers.nativefiledialogs.PlatformNotSupported;
import de.mossgrabers.nativefiledialogs.linux.NativeLinuxFileDialogs;
import de.mossgrabers.nativefiledialogs.macos.NativeMacosFileDialogs;
import de.mossgrabers.nativefiledialogs.windows.NativeWindowsFileDialogs;
import java.io.File;

public class NativeFileDialogsFactory {
    private static NativeFileDialogs instance;

    private NativeFileDialogsFactory() {
    }

    public static synchronized NativeFileDialogs create(File currentDirectory) throws PlatformNotSupported {
        if (instance == null) {
            switch (Platform.getOSType()) {
                case 2: {
                    instance = new NativeWindowsFileDialogs(currentDirectory, "bitwig");
                    break;
                }
                case 0: {
                    instance = new NativeMacosFileDialogs(currentDirectory);
                    break;
                }
                case 1: {
                    instance = new NativeLinuxFileDialogs(currentDirectory);
                    break;
                }
                default: {
                    throw new PlatformNotSupported();
                }
            }
        }
        return instance;
    }
}

