/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.widget;

import de.mossgrabers.reaper.ui.widget.NoSelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;

public class JListX<E>
extends JList<E> {
    private static final long serialVersionUID = 4796892976317717447L;

    public JListX() {
        super(new DefaultListModel());
    }

    public JListX(Collection<E> items) {
        this();
        this.addAll(items);
    }

    public void disableSelection() {
        this.setSelectionModel(new NoSelectionModel());
    }

    public boolean hasSelection() {
        return this.getSelectedIndex() != -1;
    }

    public void selectAll() {
        this.setSelectionInterval(0, ((DefaultListModel)this.getModel()).getSize() - 1);
    }

    public void setSelectItems(Collection<E> items) {
        int[] sels = new int[items.size()];
        int count = 0;
        for (E o : items) {
            sels[count++] = this.indexOf(o);
        }
        this.setSelectedIndices(sels);
    }

    public int indexOf(Object item) {
        return ((DefaultListModel)this.getModel()).indexOf(item);
    }

    public void clear() {
        ((DefaultListModel)this.getModel()).clear();
    }

    public Collection<E> getAll() {
        ListModel model = this.getModel();
        int size = model.getSize();
        ArrayList items = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            items.add(model.getElementAt(i));
        }
        return items;
    }

    public void setAll(Collection<E> items) {
        ((DefaultListModel)this.getModel()).clear();
        this.addAll(items);
    }

    public final void addAll(Collection<E> items) {
        if (items.isEmpty()) {
            return;
        }
        ListModel model = this.getModel();
        int insertPos = ((DefaultListModel)model).getSize();
        for (E o : items) {
            ((DefaultListModel)model).addElement(o);
        }
        this.setSelectedIndex(insertPos);
    }

    public void addAllIfNotPresent(Collection<E> items) {
        ListModel model = this.getModel();
        int insertPos = ((DefaultListModel)model).getSize();
        for (E o : items) {
            if (((DefaultListModel)model).contains(o)) continue;
            ((DefaultListModel)model).addElement(o);
        }
        if (insertPos != ((DefaultListModel)model).getSize()) {
            this.setSelectedIndex(insertPos);
        }
    }

    public void addItem(E item) {
        ListModel model = this.getModel();
        ((DefaultListModel)model).addElement(item);
        this.setSelectedIndex(((DefaultListModel)model).getSize() - 1);
    }

    public void addItem(int index, E item) {
        if (index == -1) {
            this.addItem(item);
        } else {
            ((DefaultListModel)this.getModel()).add(index, item);
            this.setSelectedIndex(index);
        }
    }

    public void removeItem(int index) {
        ListModel model = this.getModel();
        ((DefaultListModel)model).remove(index);
        if (!((DefaultListModel)model).isEmpty()) {
            this.setSelectedIndex(Math.max(0, index - 1));
        }
    }

    public void removeSelectedItems() {
        ListModel model = this.getModel();
        int[] sels = this.getSelectedIndices();
        if (sels.length == 0) {
            return;
        }
        for (int i = sels.length - 1; i >= 0; --i) {
            ((DefaultListModel)model).removeElementAt(sels[i]);
        }
        if (!((DefaultListModel)model).isEmpty()) {
            this.setSelectedIndex(Math.max(0, sels[0] - 1));
        }
    }

    public void replaceItem(int index, E item) {
        ListModel model = this.getModel();
        ((DefaultListModel)model).removeElementAt(index);
        ((DefaultListModel)model).insertElementAt(item, index);
        this.setSelectedIndex(index);
    }

    public void moveItem(boolean up) {
        if (up) {
            this.moveItemUp();
        } else {
            this.moveItemDown();
        }
    }

    public void moveItemUp() {
        int index = this.getSelectedIndex();
        if (index < 1) {
            return;
        }
        ListModel model = this.getModel();
        Object entry = ((DefaultListModel)model).remove(index);
        ((DefaultListModel)model).add(index - 1, entry);
        this.setSelectedIndex(index - 1);
    }

    public void moveItemDown() {
        int index = this.getSelectedIndex();
        ListModel model = this.getModel();
        if (index == -1 || index >= ((DefaultListModel)model).getSize() - 1) {
            return;
        }
        Object entry = ((DefaultListModel)model).remove(index);
        ((DefaultListModel)model).add(index + 1, entry);
        this.setSelectedIndex(index + 1);
    }

    @Override
    public DefaultListModel<E> getModel() {
        return (DefaultListModel)super.getModel();
    }

    @Override
    public void setSelectedIndex(int index) {
        super.setSelectedIndex(index);
        this.ensureIndexIsVisible(index);
    }
}

