/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.controller.hardware.BindException;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteControl;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.daw.midi.MidiShortCallback;
import de.mossgrabers.framework.daw.midi.MidiSysExCallback;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.framework.hardware.AbstractHwAbsoluteControl;
import de.mossgrabers.reaper.framework.midi.MidiConnection;
import de.mossgrabers.reaper.framework.midi.NoteInputImpl;
import de.mossgrabers.reaper.framework.midi.ReaperMidiDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class MidiInputImpl
implements IMidiInput {
    private final IHost host;
    private final BackendExchange sender;
    private final MidiConnection midiConnection;
    private final MidiDevice device;
    private final NoteInputImpl defaultNoteInput;
    private final List<NoteInputImpl> noteInputs = new ArrayList<NoteInputImpl>();
    private MidiShortCallback shortCallback;
    private MidiSysExCallback sysexCallback;
    private final Map<Integer, Map<Integer, Map<Integer, IHwButton>>> ccButtonMatchers = new HashMap<Integer, Map<Integer, Map<Integer, IHwButton>>>();
    private final Map<Integer, Map<Integer, Map<Integer, IHwButton>>> noteButtonMatchers = new HashMap<Integer, Map<Integer, Map<Integer, IHwButton>>>();
    private final Map<Integer, Map<Integer, IHwContinuousControl>> ccContinuousMatchers = new HashMap<Integer, Map<Integer, IHwContinuousControl>>();
    private final Map<Integer, IHwContinuousControl> pitchbendContinuousMatchers = new HashMap<Integer, IHwContinuousControl>();
    private final Map<Integer, Map<Integer, IHwContinuousControl>> ccTouchMatchers = new HashMap<Integer, Map<Integer, IHwContinuousControl>>();
    private final Map<Integer, Map<Integer, IHwContinuousControl>> noteTouchMatchers = new HashMap<Integer, Map<Integer, IHwContinuousControl>>();
    private final int[] lastCCValues = new int[32];
    private int noteInputIndex = 0;

    public MidiInputImpl(IHost host, BackendExchange sender, MidiConnection midiConnection, MidiDevice device, String[] filters) {
        this.host = host;
        this.sender = sender;
        this.midiConnection = midiConnection;
        this.device = device;
        this.midiConnection.setInput(this.device, (message, timeStamp) -> this.handleMidiMessage(message));
        this.defaultNoteInput = new NoteInputImpl(device, this.noteInputIndex, sender, filters);
        ++this.noteInputIndex;
        this.noteInputs.add(this.defaultNoteInput);
    }

    @Override
    public INoteInput createNoteInput(String name, String ... filters) {
        NoteInputImpl noteInput = new NoteInputImpl(this.device, this.noteInputIndex, this.sender, filters);
        ++this.noteInputIndex;
        this.noteInputs.add(noteInput);
        return noteInput;
    }

    @Override
    public void setMidiCallback(MidiShortCallback callback) {
        this.shortCallback = callback;
    }

    @Override
    public void setSysexCallback(MidiSysExCallback callback) {
        this.sysexCallback = callback;
    }

    @Override
    public void sendRawMidiEvent(int status, int data1, int data2) {
        MidiDevice midiDevice = this.device;
        if (midiDevice instanceof ReaperMidiDevice) {
            ReaperMidiDevice reaperDevice = (ReaperMidiDevice)midiDevice;
            this.sender.processMidiArg(reaperDevice.getDeviceID(), status, data1, data2);
        }
    }

    @Override
    public INoteInput getDefaultNoteInput() {
        return this.defaultNoteInput;
    }

    @Override
    public void bind(IHwButton button, BindType type, int channel, int control) {
        this.bind(button, type, channel, control, -1);
    }

    @Override
    public void bind(IHwButton button, BindType type, int channel, int control, int value) {
        if (channel == -1) {
            for (int chn = 1; chn < 16; ++chn) {
                this.internalBind(button, type, chn, control, value);
            }
            return;
        }
        this.internalBind(button, type, channel, control, value);
    }

    private void internalBind(IHwButton button, BindType type, int channel, int control, int value) {
        (switch (type) {
            case BindType.CC -> this.ccButtonMatchers.computeIfAbsent(channel, key -> new HashMap());
            case BindType.NOTE -> this.noteButtonMatchers.computeIfAbsent(channel, key -> new HashMap());
            default -> throw new BindException(type);
        }).computeIfAbsent(control, key -> new HashMap()).put(value, button);
    }

    @Override
    public void unbind(IHwButton button) {
        Collection<IHwButton> values;
        for (Map<Integer, Map<Integer, IHwButton>> m : this.ccButtonMatchers.values()) {
            for (Map<Integer, IHwButton> v : m.values()) {
                values = v.values();
                if (!values.contains(button)) continue;
                values.remove(button);
                return;
            }
        }
        for (Map<Integer, Map<Integer, IHwButton>> m : this.noteButtonMatchers.values()) {
            for (Map<Integer, IHwButton> v : m.values()) {
                values = v.values();
                if (!values.contains(button)) continue;
                values.remove(button);
                return;
            }
        }
    }

    @Override
    public void bind(IHwRelativeKnob knob, BindType type, int channel, int control, RelativeEncoding encoding) {
        this.bindContinuous(knob, type, channel, control);
    }

    @Override
    public void unbind(IHwRelativeKnob relativeKnob) {
        this.unbindContinuous(relativeKnob);
    }

    @Override
    public void bind(IHwFader fader, BindType type, int channel, int control) {
        this.bindContinuous(fader, type, channel, control);
    }

    @Override
    public void bind(IHwAbsoluteControl absoluteControl, BindType type, int channel, int control) {
        this.bindContinuous(absoluteControl, type, channel, control);
    }

    @Override
    public void bindHiRes(IHwAbsoluteControl absoluteControl, int channel, int control) {
        this.bindContinuous(absoluteControl, BindType.CC, channel, control);
        this.bindContinuous(absoluteControl, BindType.CC, channel, control + 32);
    }

    @Override
    public void unbind(IHwAbsoluteControl absoluteControl) {
        this.unbindContinuous(absoluteControl);
    }

    private void bindContinuous(IHwContinuousControl continuousControl, BindType type, int channel, int control) {
        switch (type) {
            case CC: {
                this.ccContinuousMatchers.computeIfAbsent(channel, key -> new HashMap()).put(control, continuousControl);
                break;
            }
            case PITCHBEND: {
                this.pitchbendContinuousMatchers.put(channel, continuousControl);
                break;
            }
            default: {
                throw new BindException(type);
            }
        }
    }

    private void unbindContinuous(IHwContinuousControl control) {
        for (Map<Integer, IHwContinuousControl> m : this.ccContinuousMatchers.values()) {
            Collection<IHwContinuousControl> values = m.values();
            if (!values.contains(control)) continue;
            values.remove(control);
            return;
        }
        Collection<IHwContinuousControl> values = this.pitchbendContinuousMatchers.values();
        if (values.contains(control)) {
            values.remove(control);
        }
    }

    @Override
    public void bindTouch(IHwContinuousControl continuousControl, BindType type, int channel, int control) {
        this.bindTouchContinuous(continuousControl, type, channel, control);
    }

    private void bindTouchContinuous(IHwContinuousControl continuousControl, BindType type, int channel, int control) {
        switch (type) {
            case CC: {
                this.ccTouchMatchers.computeIfAbsent(channel, key -> new HashMap()).put(control, continuousControl);
                break;
            }
            case NOTE: {
                this.noteTouchMatchers.computeIfAbsent(channel, key -> new HashMap()).put(control, continuousControl);
                break;
            }
            default: {
                throw new BindException(type);
            }
        }
    }

    public void handleMidiMessage(MidiMessage message) {
        block4: {
            try {
                if (message instanceof SysexMessage) {
                    SysexMessage sysex = (SysexMessage)message;
                    this.handleSysexMessage(sysex);
                    break block4;
                }
                if (message instanceof ShortMessage) {
                    ShortMessage sm = (ShortMessage)message;
                    this.handleShortMessage(sm);
                    break block4;
                }
                this.host.error("Unknown MIDI class.");
                return;
            }
            catch (RuntimeException ex) {
                this.host.error("Could not handle MIDI message.", ex);
            }
        }
    }

    private void handleShortMessage(ShortMessage message) {
        int data2;
        int status = message.getStatus();
        if (status == 248) {
            return;
        }
        int command = status & 0xF0;
        int channel = status & 0xF;
        int data1 = message.getData1();
        boolean isProcessed = this.handleControls(command, channel, data1, data2 = message.getData2());
        if (isProcessed && command != 144 && command != 128) {
            return;
        }
        if (this.shortCallback != null) {
            this.shortCallback.handleMidi(status, data1, data2);
        }
    }

    private boolean handleControls(int code, int channel, int data1, int data2) {
        switch (code) {
            case 176: {
                return this.handleControlsCC(channel, data1, data2);
            }
            case 128: 
            case 144: {
                return this.handleControlsNote(channel, data1, data2, code == 128 || data2 == 0);
            }
            case 224: {
                return this.handleControlsPitchbend(channel, data1, data2);
            }
        }
        return false;
    }

    protected boolean handleControlsNote(int channel, int data1, int data2, boolean isNoteOff) {
        IHwContinuousControl ccButton;
        Map<Integer, IHwContinuousControl> noteTouchMap;
        Map<Integer, IHwButton> valueMap;
        Map<Integer, Map<Integer, IHwButton>> noteMap = this.noteButtonMatchers.get(channel);
        if (noteMap != null && (valueMap = noteMap.get(data1)) != null) {
            for (Map.Entry<Integer, IHwButton> valueButtonPair : valueMap.entrySet()) {
                int value = valueButtonPair.getKey();
                if (value != -1 && value != data2) continue;
                valueButtonPair.getValue().trigger(isNoteOff ? ButtonEvent.UP : ButtonEvent.DOWN, (double)data2 / 127.0);
                return true;
            }
        }
        if ((noteTouchMap = this.noteTouchMatchers.get(channel)) != null && (ccButton = noteTouchMap.get(data1)) != null && ccButton.isBound()) {
            ccButton.triggerTouch(!isNoteOff);
            return true;
        }
        return false;
    }

    protected boolean handleControlsCC(int channel, int data1, int data2) {
        IHwContinuousControl ccContinuous;
        IHwContinuousControl ccButton;
        Map<Integer, IHwContinuousControl> ccTouchMap;
        Map<Integer, IHwButton> valueMap;
        Map<Integer, Map<Integer, IHwButton>> ccButtonMap = this.ccButtonMatchers.get(channel);
        if (ccButtonMap != null && (valueMap = ccButtonMap.get(data1)) != null) {
            for (Map.Entry<Integer, IHwButton> valueButtonPair : valueMap.entrySet()) {
                int value = valueButtonPair.getKey();
                if (value != -1 && value != data2) continue;
                ButtonEvent event = value == 0 || data2 > 0 ? ButtonEvent.DOWN : ButtonEvent.UP;
                valueButtonPair.getValue().trigger(event, (double)data2 / 127.0);
                return true;
            }
        }
        if ((ccTouchMap = this.ccTouchMatchers.get(channel)) != null && (ccButton = ccTouchMap.get(data1)) != null && ccButton.isBound()) {
            ccButton.triggerTouch(data2 > 0);
            return true;
        }
        Map<Integer, IHwContinuousControl> ccContinuousMap = this.ccContinuousMatchers.get(channel);
        if (ccContinuousMap != null && (ccContinuous = ccContinuousMap.get(data1)) != null && ccContinuous.isBound()) {
            AbstractHwAbsoluteControl ac;
            if (ccContinuous instanceof AbstractHwAbsoluteControl && (ac = (AbstractHwAbsoluteControl)ccContinuous).isHiRes()) {
                if (data1 < 32) {
                    this.lastCCValues[data1] = data2;
                } else if (data1 < 64) {
                    int value = this.lastCCValues[data1 - 32] * 128 + data2;
                    ccContinuous.handleValue((double)value / 16383.0);
                }
                return true;
            }
            ccContinuous.handleValue((double)data2 / 127.0);
            return true;
        }
        return false;
    }

    protected boolean handleControlsPitchbend(int channel, int data1, int data2) {
        IHwContinuousControl pbContinuous = this.pitchbendContinuousMatchers.get(channel);
        if (pbContinuous != null && pbContinuous.isBound()) {
            int pitchbendValue = data2 * 128 + data1;
            pbContinuous.handleValue((double)pitchbendValue / 16383.0);
            return true;
        }
        return false;
    }

    private void handleSysexMessage(SysexMessage sysexMessage) {
        if (this.sysexCallback == null) {
            return;
        }
        StringBuilder dataString = new StringBuilder();
        for (byte data : sysexMessage.getMessage()) {
            dataString.append(String.format("%02x", data & 0xFF));
        }
        this.sysexCallback.handleMidi(dataString.toString().toUpperCase(Locale.US));
    }
}

